package io.strimzi.api.kafka.model.listener.arraylistener;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface GenericKafkaListenerConfigurationBrokerFluent<A extends GenericKafkaListenerConfigurationBrokerFluent<A>> extends Fluent<A>{


    public Integer getBroker();
    public A withBroker(Integer broker);
    public Boolean hasBroker();
    public String getAdvertisedHost();
    public A withAdvertisedHost(String advertisedHost);
    public Boolean hasAdvertisedHost();
    public A withNewAdvertisedHost(String arg1);
    public A withNewAdvertisedHost(StringBuilder arg1);
    public A withNewAdvertisedHost(StringBuffer arg1);
    public Integer getAdvertisedPort();
    public A withAdvertisedPort(Integer advertisedPort);
    public Boolean hasAdvertisedPort();
    public String getHost();
    public A withHost(String host);
    public Boolean hasHost();
    public A withNewHost(String arg1);
    public A withNewHost(StringBuilder arg1);
    public A withNewHost(StringBuffer arg1);
    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public Integer getNodePort();
    public A withNodePort(Integer nodePort);
    public Boolean hasNodePort();
    public String getLoadBalancerIP();
    public A withLoadBalancerIP(String loadBalancerIP);
    public Boolean hasLoadBalancerIP();
    public A withNewLoadBalancerIP(String arg1);
    public A withNewLoadBalancerIP(StringBuilder arg1);
    public A withNewLoadBalancerIP(StringBuffer arg1);



}
