package io.strimzi.api.kafka.model.listener.arraylistener;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class GenericKafkaListenerConfigurationBrokerFluentImpl<A extends GenericKafkaListenerConfigurationBrokerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GenericKafkaListenerConfigurationBrokerFluent<A>{

    private Integer broker;
    private String advertisedHost;
    private Integer advertisedPort;
    private String host;
    private Map<String,String> annotations;
    private Integer nodePort;
    private String loadBalancerIP;

    public GenericKafkaListenerConfigurationBrokerFluentImpl(){
    }
    public GenericKafkaListenerConfigurationBrokerFluentImpl(GenericKafkaListenerConfigurationBroker instance){
            this.withBroker(instance.getBroker());

            this.withAdvertisedHost(instance.getAdvertisedHost());

            this.withAdvertisedPort(instance.getAdvertisedPort());

            this.withHost(instance.getHost());

            this.withAnnotations(instance.getAnnotations());

            this.withNodePort(instance.getNodePort());

            this.withLoadBalancerIP(instance.getLoadBalancerIP());

    }

    public Integer getBroker(){
            return this.broker;
    }

    public A withBroker(Integer broker){
            this.broker=broker; return (A) this;
    }

    public Boolean hasBroker(){
            return this.broker != null;
    }

    public String getAdvertisedHost(){
            return this.advertisedHost;
    }

    public A withAdvertisedHost(String advertisedHost){
            this.advertisedHost=advertisedHost; return (A) this;
    }

    public Boolean hasAdvertisedHost(){
            return this.advertisedHost != null;
    }

    public A withNewAdvertisedHost(String arg1){
            return (A)withAdvertisedHost(new String(arg1));
    }

    public A withNewAdvertisedHost(StringBuilder arg1){
            return (A)withAdvertisedHost(new String(arg1));
    }

    public A withNewAdvertisedHost(StringBuffer arg1){
            return (A)withAdvertisedHost(new String(arg1));
    }

    public Integer getAdvertisedPort(){
            return this.advertisedPort;
    }

    public A withAdvertisedPort(Integer advertisedPort){
            this.advertisedPort=advertisedPort; return (A) this;
    }

    public Boolean hasAdvertisedPort(){
            return this.advertisedPort != null;
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    public A addToAnnotations(String key,String value){
            if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map){
            if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
            if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key){
            if(this.annotations == null) { return (A) this; }
            if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map){
            if(this.annotations == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotations(){
            return this.annotations;
    }

    public A withAnnotations(Map<String,String> annotations){
            if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations(){
            return this.annotations != null;
    }

    public Integer getNodePort(){
            return this.nodePort;
    }

    public A withNodePort(Integer nodePort){
            this.nodePort=nodePort; return (A) this;
    }

    public Boolean hasNodePort(){
            return this.nodePort != null;
    }

    public String getLoadBalancerIP(){
            return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(String loadBalancerIP){
            this.loadBalancerIP=loadBalancerIP; return (A) this;
    }

    public Boolean hasLoadBalancerIP(){
            return this.loadBalancerIP != null;
    }

    public A withNewLoadBalancerIP(String arg1){
            return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(StringBuilder arg1){
            return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(StringBuffer arg1){
            return (A)withLoadBalancerIP(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            GenericKafkaListenerConfigurationBrokerFluentImpl that = (GenericKafkaListenerConfigurationBrokerFluentImpl) o;
            if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
            if (advertisedHost != null ? !advertisedHost.equals(that.advertisedHost) :that.advertisedHost != null) return false;
            if (advertisedPort != null ? !advertisedPort.equals(that.advertisedPort) :that.advertisedPort != null) return false;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
            if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
            if (loadBalancerIP != null ? !loadBalancerIP.equals(that.loadBalancerIP) :that.loadBalancerIP != null) return false;
            return true;
    }




}
