package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GenericKafkaListenerConfigurationBuilder extends GenericKafkaListenerConfigurationFluentImpl<GenericKafkaListenerConfigurationBuilder> implements VisitableBuilder<GenericKafkaListenerConfiguration,GenericKafkaListenerConfigurationBuilder>{

    GenericKafkaListenerConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public GenericKafkaListenerConfigurationBuilder(){
            this(true);
    }
    public GenericKafkaListenerConfigurationBuilder(Boolean validationEnabled){
            this(new GenericKafkaListenerConfiguration(), validationEnabled);
    }
    public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent){
            this(fluent, true);
    }
    public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GenericKafkaListenerConfiguration(), validationEnabled);
    }
    public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent,GenericKafkaListenerConfiguration instance){
            this(fluent, instance, true);
    }
    public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent,GenericKafkaListenerConfiguration instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());

            fluent.withIngressClass(instance.getIngressClass());

            fluent.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());

            fluent.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());

            fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());

            fluent.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());

            fluent.withBootstrap(instance.getBootstrap());

            fluent.withBrokers(instance.getBrokers());

            this.validationEnabled = validationEnabled; 
    }
    public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfiguration instance){
            this(instance,true);
    }
    public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfiguration instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());

            this.withIngressClass(instance.getIngressClass());

            this.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());

            this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());

            this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());

            this.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());

            this.withBootstrap(instance.getBootstrap());

            this.withBrokers(instance.getBrokers());

            this.validationEnabled = validationEnabled; 
    }

    public GenericKafkaListenerConfiguration build(){
            GenericKafkaListenerConfiguration buildable = new GenericKafkaListenerConfiguration();
            buildable.setBrokerCertChainAndKey(fluent.getBrokerCertChainAndKey());
            buildable.setIngressClass(fluent.getIngressClass());
            buildable.setPreferredNodePortAddressType(fluent.getPreferredNodePortAddressType());
            buildable.setExternalTrafficPolicy(fluent.getExternalTrafficPolicy());
            buildable.setLoadBalancerSourceRanges(fluent.getLoadBalancerSourceRanges());
            buildable.setUseServiceDnsDomain(fluent.isUseServiceDnsDomain());
            buildable.setBootstrap(fluent.getBootstrap());
            buildable.setBrokers(fluent.getBrokers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GenericKafkaListenerConfigurationBuilder that = (GenericKafkaListenerConfigurationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
