package io.strimzi.api.kafka.model.listener.arraylistener;

import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth;
import java.lang.String;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import java.lang.Deprecated;
import java.util.List;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface GenericKafkaListenerFluent<A extends GenericKafkaListenerFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public int getPort();
    public A withPort(int port);
    public Boolean hasPort();
    public KafkaListenerType getType();
    public A withType(KafkaListenerType type);
    public Boolean hasType();
    public boolean isTls();
    public A withTls(boolean tls);
    public Boolean hasTls();
    
/**
 * This method has been deprecated, please use method buildAuth instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListenerAuthentication getAuth();
    public KafkaListenerAuthentication buildAuth();
    public A withAuth(KafkaListenerAuthentication auth);
    public Boolean hasAuth();
    public A withKafkaListenerAuthenticationOAuth(KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth);
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth();
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item);
    public A withKafkaListenerAuthenticationTlsAuth(KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth);
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth();
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item);
    public A withKafkaListenerAuthenticationScramSha512Auth(KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth);
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth();
    public GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item);
    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public GenericKafkaListenerConfiguration getConfiguration();
    public GenericKafkaListenerConfiguration buildConfiguration();
    public A withConfiguration(GenericKafkaListenerConfiguration configuration);
    public Boolean hasConfiguration();
    public GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfiguration();
    public GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfigurationLike(GenericKafkaListenerConfiguration item);
    public GenericKafkaListenerFluent.ConfigurationNested<A> editConfiguration();
    public GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfiguration();
    public GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfigurationLike(GenericKafkaListenerConfiguration item);
    public A addToNetworkPolicyPeers(int index,NetworkPolicyPeer item);
    public A setToNetworkPolicyPeers(int index,NetworkPolicyPeer item);
    public A addToNetworkPolicyPeers(NetworkPolicyPeer... items);
    public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items);
    public A removeFromNetworkPolicyPeers(NetworkPolicyPeer... items);
    public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items);
    public java.util.List<NetworkPolicyPeer> getNetworkPolicyPeers();
    public NetworkPolicyPeer getNetworkPolicyPeer(int index);
    public NetworkPolicyPeer getFirstNetworkPolicyPeer();
    public NetworkPolicyPeer getLastNetworkPolicyPeer();
    public NetworkPolicyPeer getMatchingNetworkPolicyPeer(io.fabric8.kubernetes.api.builder.Predicate<NetworkPolicyPeer> predicate);
    public Boolean hasMatchingNetworkPolicyPeer(io.fabric8.kubernetes.api.builder.Predicate<NetworkPolicyPeer> predicate);
    public A withNetworkPolicyPeers(java.util.List<NetworkPolicyPeer> networkPolicyPeers);
    public A withNetworkPolicyPeers(NetworkPolicyPeer... networkPolicyPeers);
    public Boolean hasNetworkPolicyPeers();

    public interface KafkaListenerAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaListenerAuthenticationOAuthFluent<GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<N>>{

        
    public N and();    public N endKafkaListenerAuthenticationOAuth();
}
    public interface KafkaListenerAuthenticationTlsAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaListenerAuthenticationTlsFluent<GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<N>>{

        
    public N and();    public N endKafkaListenerAuthenticationTlsAuth();
}
    public interface KafkaListenerAuthenticationScramSha512AuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaListenerAuthenticationScramSha512Fluent<GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>>{

        
    public N and();    public N endKafkaListenerAuthenticationScramSha512Auth();
}
    public interface ConfigurationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenericKafkaListenerConfigurationFluent<GenericKafkaListenerFluent.ConfigurationNested<N>>{

        
    public N and();    public N endConfiguration();
}


}
