package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeStatusBuilder extends KafkaBridgeStatusFluentImpl<KafkaBridgeStatusBuilder> implements VisitableBuilder<KafkaBridgeStatus,KafkaBridgeStatusBuilder>{

    KafkaBridgeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeStatusBuilder(){
            this(true);
    }
    public KafkaBridgeStatusBuilder(Boolean validationEnabled){
            this(new KafkaBridgeStatus(), validationEnabled);
    }
    public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaBridgeStatus(), validationEnabled);
    }
    public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent,KafkaBridgeStatus instance){
            this(fluent, instance, true);
    }
    public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent,KafkaBridgeStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUrl(instance.getUrl());

            fluent.withReplicas(instance.getReplicas());

            fluent.withLabelSelector(instance.getLabelSelector());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaBridgeStatusBuilder(KafkaBridgeStatus instance){
            this(instance,true);
    }
    public KafkaBridgeStatusBuilder(KafkaBridgeStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUrl(instance.getUrl());

            this.withReplicas(instance.getReplicas());

            this.withLabelSelector(instance.getLabelSelector());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeStatus build(){
            KafkaBridgeStatus buildable = new KafkaBridgeStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setUrl(fluent.getUrl());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setLabelSelector(fluent.getLabelSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaBridgeStatusBuilder that = (KafkaBridgeStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
