package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectStatusBuilder extends KafkaConnectStatusFluentImpl<KafkaConnectStatusBuilder> implements VisitableBuilder<KafkaConnectStatus,KafkaConnectStatusBuilder>{

    KafkaConnectStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectStatusBuilder(){
            this(true);
    }
    public KafkaConnectStatusBuilder(Boolean validationEnabled){
            this(new KafkaConnectStatus(), validationEnabled);
    }
    public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaConnectStatus(), validationEnabled);
    }
    public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent,KafkaConnectStatus instance){
            this(fluent, instance, true);
    }
    public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent,KafkaConnectStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUrl(instance.getUrl());

            fluent.withConnectorPlugins(instance.getConnectorPlugins());

            fluent.withReplicas(instance.getReplicas());

            fluent.withLabelSelector(instance.getLabelSelector());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaConnectStatusBuilder(KafkaConnectStatus instance){
            this(instance,true);
    }
    public KafkaConnectStatusBuilder(KafkaConnectStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUrl(instance.getUrl());

            this.withConnectorPlugins(instance.getConnectorPlugins());

            this.withReplicas(instance.getReplicas());

            this.withLabelSelector(instance.getLabelSelector());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectStatus build(){
            KafkaConnectStatus buildable = new KafkaConnectStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setUrl(fluent.getUrl());
            buildable.setConnectorPlugins(fluent.getConnectorPlugins());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setLabelSelector(fluent.getLabelSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectStatusBuilder that = (KafkaConnectStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
