package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectorStatusBuilder extends KafkaConnectorStatusFluentImpl<KafkaConnectorStatusBuilder> implements VisitableBuilder<KafkaConnectorStatus,KafkaConnectorStatusBuilder>{

    KafkaConnectorStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectorStatusBuilder(){
            this(true);
    }
    public KafkaConnectorStatusBuilder(Boolean validationEnabled){
            this(new KafkaConnectorStatus(), validationEnabled);
    }
    public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaConnectorStatus(), validationEnabled);
    }
    public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent,KafkaConnectorStatus instance){
            this(fluent, instance, true);
    }
    public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent,KafkaConnectorStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConnectorStatus(instance.getConnectorStatus());

            fluent.withTasksMax(instance.getTasksMax());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaConnectorStatusBuilder(KafkaConnectorStatus instance){
            this(instance,true);
    }
    public KafkaConnectorStatusBuilder(KafkaConnectorStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConnectorStatus(instance.getConnectorStatus());

            this.withTasksMax(instance.getTasksMax());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectorStatus build(){
            KafkaConnectorStatus buildable = new KafkaConnectorStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setConnectorStatus(fluent.getConnectorStatus());
            buildable.setTasksMax(fluent.getTasksMax());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectorStatusBuilder that = (KafkaConnectorStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
