package io.strimzi.api.kafka.model.status;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class KafkaConnectorStatusFluentImpl<A extends KafkaConnectorStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaConnectorStatusFluent<A>{

    private Map<String,Object> connectorStatus;
    private int tasksMax;

    public KafkaConnectorStatusFluentImpl(){
    }
    public KafkaConnectorStatusFluentImpl(KafkaConnectorStatus instance){
            this.withConnectorStatus(instance.getConnectorStatus());

            this.withTasksMax(instance.getTasksMax());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

    }

    public A addToConnectorStatus(String key,Object value){
            if(this.connectorStatus == null && key != null && value != null) { this.connectorStatus = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.connectorStatus.put(key, value);} return (A)this;
    }

    public A addToConnectorStatus(Map<String,Object> map){
            if(this.connectorStatus == null && map != null) { this.connectorStatus = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.connectorStatus.putAll(map);} return (A)this;
    }

    public A removeFromConnectorStatus(String key){
            if(this.connectorStatus == null) { return (A) this; }
            if(key != null && this.connectorStatus != null) {this.connectorStatus.remove(key);} return (A)this;
    }

    public A removeFromConnectorStatus(Map<String,Object> map){
            if(this.connectorStatus == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.connectorStatus != null){this.connectorStatus.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConnectorStatus(){
            return this.connectorStatus;
    }

    public A withConnectorStatus(Map<String,Object> connectorStatus){
            if (connectorStatus == null) { this.connectorStatus =  null;} else {this.connectorStatus = new LinkedHashMap<String,Object>(connectorStatus);} return (A) this;
    }

    public Boolean hasConnectorStatus(){
            return this.connectorStatus != null;
    }

    public int getTasksMax(){
            return this.tasksMax;
    }

    public A withTasksMax(int tasksMax){
            this.tasksMax=tasksMax; return (A) this;
    }

    public Boolean hasTasksMax(){
            return true;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectorStatusFluentImpl that = (KafkaConnectorStatusFluentImpl) o;
            if (connectorStatus != null ? !connectorStatus.equals(that.connectorStatus) :that.connectorStatus != null) return false;
            if (tasksMax != that.tasksMax) return false;
            return true;
    }




}
