package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2StatusBuilder extends KafkaMirrorMaker2StatusFluentImpl<KafkaMirrorMaker2StatusBuilder> implements VisitableBuilder<KafkaMirrorMaker2Status,KafkaMirrorMaker2StatusBuilder>{

    KafkaMirrorMaker2StatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMaker2StatusBuilder(){
            this(true);
    }
    public KafkaMirrorMaker2StatusBuilder(Boolean validationEnabled){
            this(new KafkaMirrorMaker2Status(), validationEnabled);
    }
    public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2StatusFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2StatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaMirrorMaker2Status(), validationEnabled);
    }
    public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2StatusFluent<?> fluent,KafkaMirrorMaker2Status instance){
            this(fluent, instance, true);
    }
    public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2StatusFluent<?> fluent,KafkaMirrorMaker2Status instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConnectors(instance.getConnectors());

            fluent.withUrl(instance.getUrl());

            fluent.withConnectorPlugins(instance.getConnectorPlugins());

            fluent.withReplicas(instance.getReplicas());

            fluent.withLabelSelector(instance.getLabelSelector());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2Status instance){
            this(instance,true);
    }
    public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2Status instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConnectors(instance.getConnectors());

            this.withUrl(instance.getUrl());

            this.withConnectorPlugins(instance.getConnectorPlugins());

            this.withReplicas(instance.getReplicas());

            this.withLabelSelector(instance.getLabelSelector());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2Status build(){
            KafkaMirrorMaker2Status buildable = new KafkaMirrorMaker2Status();
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setUrl(fluent.getUrl());
            buildable.setConnectorPlugins(fluent.getConnectorPlugins());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setLabelSelector(fluent.getLabelSelector());
            buildable.setConnectors(fluent.getConnectors());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMaker2StatusBuilder that = (KafkaMirrorMaker2StatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
