package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaRebalanceStatusBuilder extends KafkaRebalanceStatusFluentImpl<KafkaRebalanceStatusBuilder> implements VisitableBuilder<KafkaRebalanceStatus,KafkaRebalanceStatusBuilder>{

    KafkaRebalanceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaRebalanceStatusBuilder(){
            this(true);
    }
    public KafkaRebalanceStatusBuilder(Boolean validationEnabled){
            this(new KafkaRebalanceStatus(), validationEnabled);
    }
    public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaRebalanceStatus(), validationEnabled);
    }
    public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent,KafkaRebalanceStatus instance){
            this(fluent, instance, true);
    }
    public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent,KafkaRebalanceStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSessionId(instance.getSessionId());

            fluent.withOptimizationResult(instance.getOptimizationResult());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaRebalanceStatusBuilder(KafkaRebalanceStatus instance){
            this(instance,true);
    }
    public KafkaRebalanceStatusBuilder(KafkaRebalanceStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSessionId(instance.getSessionId());

            this.withOptimizationResult(instance.getOptimizationResult());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaRebalanceStatus build(){
            KafkaRebalanceStatus buildable = new KafkaRebalanceStatus();
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setSessionId(fluent.getSessionId());
            buildable.setOptimizationResult(fluent.getOptimizationResult());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaRebalanceStatusBuilder that = (KafkaRebalanceStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
