package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface KafkaStatusFluent<A extends KafkaStatusFluent<A>> extends StatusFluent<A>{


    public A addToListeners(int index,ListenerStatus item);
    public A setToListeners(int index,ListenerStatus item);
    public A addToListeners(ListenerStatus... items);
    public A addAllToListeners(Collection<ListenerStatus> items);
    public A removeFromListeners(ListenerStatus... items);
    public A removeAllFromListeners(Collection<ListenerStatus> items);
    public A removeMatchingFromListeners(io.fabric8.kubernetes.api.builder.Predicate<ListenerStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildListeners instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<ListenerStatus> getListeners();
    public java.util.List<ListenerStatus> buildListeners();
    public ListenerStatus buildListener(int index);
    public ListenerStatus buildFirstListener();
    public ListenerStatus buildLastListener();
    public ListenerStatus buildMatchingListener(io.fabric8.kubernetes.api.builder.Predicate<ListenerStatusBuilder> predicate);
    public Boolean hasMatchingListener(io.fabric8.kubernetes.api.builder.Predicate<ListenerStatusBuilder> predicate);
    public A withListeners(java.util.List<ListenerStatus> listeners);
    public A withListeners(ListenerStatus... listeners);
    public Boolean hasListeners();
    public KafkaStatusFluent.ListenersNested<A> addNewListener();
    public KafkaStatusFluent.ListenersNested<A> addNewListenerLike(ListenerStatus item);
    public KafkaStatusFluent.ListenersNested<A> setNewListenerLike(int index,ListenerStatus item);
    public KafkaStatusFluent.ListenersNested<A> editListener(int index);
    public KafkaStatusFluent.ListenersNested<A> editFirstListener();
    public KafkaStatusFluent.ListenersNested<A> editLastListener();
    public KafkaStatusFluent.ListenersNested<A> editMatchingListener(io.fabric8.kubernetes.api.builder.Predicate<ListenerStatusBuilder> predicate);
    public String getClusterId();
    public A withClusterId(String clusterId);
    public Boolean hasClusterId();
    public A withNewClusterId(String arg1);
    public A withNewClusterId(StringBuilder arg1);
    public A withNewClusterId(StringBuffer arg1);

    public interface ListenersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListenerStatusFluent<KafkaStatusFluent.ListenersNested<N>>{

        
    public N and();    public N endListener();
}


}
