package io.strimzi.api.kafka.model.status;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ListenerAddressFluentImpl<A extends ListenerAddressFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ListenerAddressFluent<A>{

    private String host;
    private Integer port;

    public ListenerAddressFluentImpl(){
    }
    public ListenerAddressFluentImpl(ListenerAddress instance){
            this.withHost(instance.getHost());

            this.withPort(instance.getPort());

    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ListenerAddressFluentImpl that = (ListenerAddressFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            return true;
    }




}
