package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ListenerStatusFluent<A extends ListenerStatusFluent<A>> extends Fluent<A>{


    public String getType();
    public A withType(String type);
    public Boolean hasType();
    public A withNewType(String arg1);
    public A withNewType(StringBuilder arg1);
    public A withNewType(StringBuffer arg1);
    public A addToAddresses(int index,ListenerAddress item);
    public A setToAddresses(int index,ListenerAddress item);
    public A addToAddresses(ListenerAddress... items);
    public A addAllToAddresses(Collection<ListenerAddress> items);
    public A removeFromAddresses(ListenerAddress... items);
    public A removeAllFromAddresses(Collection<ListenerAddress> items);
    public A removeMatchingFromAddresses(io.fabric8.kubernetes.api.builder.Predicate<ListenerAddressBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAddresses instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<ListenerAddress> getAddresses();
    public java.util.List<ListenerAddress> buildAddresses();
    public ListenerAddress buildAddress(int index);
    public ListenerAddress buildFirstAddress();
    public ListenerAddress buildLastAddress();
    public ListenerAddress buildMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<ListenerAddressBuilder> predicate);
    public Boolean hasMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<ListenerAddressBuilder> predicate);
    public A withAddresses(java.util.List<ListenerAddress> addresses);
    public A withAddresses(ListenerAddress... addresses);
    public Boolean hasAddresses();
    public ListenerStatusFluent.AddressesNested<A> addNewAddress();
    public ListenerStatusFluent.AddressesNested<A> addNewAddressLike(ListenerAddress item);
    public ListenerStatusFluent.AddressesNested<A> setNewAddressLike(int index,ListenerAddress item);
    public ListenerStatusFluent.AddressesNested<A> editAddress(int index);
    public ListenerStatusFluent.AddressesNested<A> editFirstAddress();
    public ListenerStatusFluent.AddressesNested<A> editLastAddress();
    public ListenerStatusFluent.AddressesNested<A> editMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<ListenerAddressBuilder> predicate);
    public A addToCertificates(int index,String item);
    public A setToCertificates(int index,String item);
    public A addToCertificates(String... items);
    public A addAllToCertificates(Collection<String> items);
    public A removeFromCertificates(String... items);
    public A removeAllFromCertificates(Collection<String> items);
    public java.util.List<String> getCertificates();
    public String getCertificate(int index);
    public String getFirstCertificate();
    public String getLastCertificate();
    public String getMatchingCertificate(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingCertificate(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withCertificates(java.util.List<String> certificates);
    public A withCertificates(String... certificates);
    public Boolean hasCertificates();
    public A addNewCertificate(String arg1);
    public A addNewCertificate(StringBuilder arg1);
    public A addNewCertificate(StringBuffer arg1);

    public interface AddressesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListenerAddressFluent<ListenerStatusFluent.AddressesNested<N>>{

        
    public N and();    public N endAddress();
}


}
