package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JbodStorageBuilder extends JbodStorageFluentImpl<JbodStorageBuilder> implements VisitableBuilder<JbodStorage,JbodStorageBuilder>{

    JbodStorageFluent<?> fluent;
    Boolean validationEnabled;

    public JbodStorageBuilder(){
            this(true);
    }
    public JbodStorageBuilder(Boolean validationEnabled){
            this(new JbodStorage(), validationEnabled);
    }
    public JbodStorageBuilder(JbodStorageFluent<?> fluent){
            this(fluent, true);
    }
    public JbodStorageBuilder(JbodStorageFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JbodStorage(), validationEnabled);
    }
    public JbodStorageBuilder(JbodStorageFluent<?> fluent,JbodStorage instance){
            this(fluent, instance, true);
    }
    public JbodStorageBuilder(JbodStorageFluent<?> fluent,JbodStorage instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }
    public JbodStorageBuilder(JbodStorage instance){
            this(instance,true);
    }
    public JbodStorageBuilder(JbodStorage instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }

    public JbodStorage build(){
            JbodStorage buildable = new JbodStorage();
            buildable.setVolumes(fluent.getVolumes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JbodStorageBuilder that = (JbodStorageBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
