package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class PersistentClaimStorageFluentImpl<A extends PersistentClaimStorageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PersistentClaimStorageFluent<A>{

    private String size;
    private String storageClass;
    private Map<String,String> selector;
    private boolean deleteClaim;
    private java.util.List<PersistentClaimStorageOverrideBuilder> overrides;
    private Integer id;

    public PersistentClaimStorageFluentImpl(){
    }
    public PersistentClaimStorageFluentImpl(PersistentClaimStorage instance){
            this.withSize(instance.getSize());

            this.withStorageClass(instance.getStorageClass());

            this.withSelector(instance.getSelector());

            this.withDeleteClaim(instance.isDeleteClaim());

            this.withOverrides(instance.getOverrides());

            this.withId(instance.getId());

    }

    public String getSize(){
            return this.size;
    }

    public A withSize(String size){
            this.size=size; return (A) this;
    }

    public Boolean hasSize(){
            return this.size != null;
    }

    public A withNewSize(String arg1){
            return (A)withSize(new String(arg1));
    }

    public A withNewSize(StringBuilder arg1){
            return (A)withSize(new String(arg1));
    }

    public A withNewSize(StringBuffer arg1){
            return (A)withSize(new String(arg1));
    }

    public String getStorageClass(){
            return this.storageClass;
    }

    public A withStorageClass(String storageClass){
            this.storageClass=storageClass; return (A) this;
    }

    public Boolean hasStorageClass(){
            return this.storageClass != null;
    }

    public A withNewStorageClass(String arg1){
            return (A)withStorageClass(new String(arg1));
    }

    public A withNewStorageClass(StringBuilder arg1){
            return (A)withStorageClass(new String(arg1));
    }

    public A withNewStorageClass(StringBuffer arg1){
            return (A)withStorageClass(new String(arg1));
    }

    public A addToSelector(String key,String value){
            if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
    }

    public A addToSelector(Map<String,String> map){
            if(this.selector == null && map != null) { this.selector = new LinkedHashMap<String,String>(); }
            if(map != null) { this.selector.putAll(map);} return (A)this;
    }

    public A removeFromSelector(String key){
            if(this.selector == null) { return (A) this; }
            if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
    }

    public A removeFromSelector(Map<String,String> map){
            if(this.selector == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getSelector(){
            return this.selector;
    }

    public A withSelector(Map<String,String> selector){
            if (selector == null) { this.selector =  null;} else {this.selector = new LinkedHashMap<String,String>(selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public boolean isDeleteClaim(){
            return this.deleteClaim;
    }

    public A withDeleteClaim(boolean deleteClaim){
            this.deleteClaim=deleteClaim; return (A) this;
    }

    public Boolean hasDeleteClaim(){
            return true;
    }

    public A addToOverrides(int index,PersistentClaimStorageOverride item){
            if (this.overrides == null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();}
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").add(index >= 0 ? index : _visitables.get("overrides").size(), builder);this.overrides.add(index >= 0 ? index : overrides.size(), builder); return (A)this;
    }

    public A setToOverrides(int index,PersistentClaimStorageOverride item){
            if (this.overrides == null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();}
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            if (index < 0 || index >= _visitables.get("overrides").size()) { _visitables.get("overrides").add(builder); } else { _visitables.get("overrides").set(index, builder);}
            if (index < 0 || index >= overrides.size()) { overrides.add(builder); } else { overrides.set(index, builder);}
             return (A)this;
    }

    public A addToOverrides(PersistentClaimStorageOverride... items){
            if (this.overrides == null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();}
            for (PersistentClaimStorageOverride item : items) {PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
    }

    public A addAllToOverrides(Collection<PersistentClaimStorageOverride> items){
            if (this.overrides == null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>();}
            for (PersistentClaimStorageOverride item : items) {PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
    }

    public A removeFromOverrides(PersistentClaimStorageOverride... items){
            for (PersistentClaimStorageOverride item : items) {PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
    }

    public A removeAllFromOverrides(Collection<PersistentClaimStorageOverride> items){
            for (PersistentClaimStorageOverride item : items) {PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOverrides(io.fabric8.kubernetes.api.builder.Predicate<PersistentClaimStorageOverrideBuilder> predicate){
            if (overrides == null) return (A) this;
            final Iterator<PersistentClaimStorageOverrideBuilder> each = overrides.iterator();
            final List visitables = _visitables.get("overrides");
            while (each.hasNext()) {
              PersistentClaimStorageOverrideBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOverrides instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<PersistentClaimStorageOverride> getOverrides(){
            return build(overrides);
    }

    public java.util.List<PersistentClaimStorageOverride> buildOverrides(){
            return build(overrides);
    }

    public PersistentClaimStorageOverride buildOverride(int index){
            return this.overrides.get(index).build();
    }

    public PersistentClaimStorageOverride buildFirstOverride(){
            return this.overrides.get(0).build();
    }

    public PersistentClaimStorageOverride buildLastOverride(){
            return this.overrides.get(overrides.size() - 1).build();
    }

    public PersistentClaimStorageOverride buildMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<PersistentClaimStorageOverrideBuilder> predicate){
            for (PersistentClaimStorageOverrideBuilder item: overrides) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<PersistentClaimStorageOverrideBuilder> predicate){
            for (PersistentClaimStorageOverrideBuilder item: overrides) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withOverrides(java.util.List<PersistentClaimStorageOverride> overrides){
            if (this.overrides != null) { _visitables.get("overrides").removeAll(this.overrides);}
            if (overrides != null) {this.overrides = new ArrayList<PersistentClaimStorageOverrideBuilder>(); for (PersistentClaimStorageOverride item : overrides){this.addToOverrides(item);}} else { this.overrides = null;} return (A) this;
    }

    public A withOverrides(PersistentClaimStorageOverride... overrides){
            if (this.overrides != null) {this.overrides.clear();}
            if (overrides != null) {for (PersistentClaimStorageOverride item :overrides){ this.addToOverrides(item);}} return (A) this;
    }

    public Boolean hasOverrides(){
            return overrides != null && !overrides.isEmpty();
    }

    public PersistentClaimStorageFluent.OverridesNested<A> addNewOverride(){
            return new OverridesNestedImpl();
    }

    public PersistentClaimStorageFluent.OverridesNested<A> addNewOverrideLike(PersistentClaimStorageOverride item){
            return new OverridesNestedImpl(-1, item);
    }

    public PersistentClaimStorageFluent.OverridesNested<A> setNewOverrideLike(int index,PersistentClaimStorageOverride item){
            return new OverridesNestedImpl(index, item);
    }

    public PersistentClaimStorageFluent.OverridesNested<A> editOverride(int index){
            if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
            return setNewOverrideLike(index, buildOverride(index));
    }

    public PersistentClaimStorageFluent.OverridesNested<A> editFirstOverride(){
            if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
            return setNewOverrideLike(0, buildOverride(0));
    }

    public PersistentClaimStorageFluent.OverridesNested<A> editLastOverride(){
            int index = overrides.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
            return setNewOverrideLike(index, buildOverride(index));
    }

    public PersistentClaimStorageFluent.OverridesNested<A> editMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<PersistentClaimStorageOverrideBuilder> predicate){
            int index = -1;
            for (int i=0;i<overrides.size();i++) { 
            if (predicate.apply(overrides.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
            return setNewOverrideLike(index, buildOverride(index));
    }

    public Integer getId(){
            return this.id;
    }

    public A withId(Integer id){
            this.id=id; return (A) this;
    }

    public Boolean hasId(){
            return this.id != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PersistentClaimStorageFluentImpl that = (PersistentClaimStorageFluentImpl) o;
            if (size != null ? !size.equals(that.size) :that.size != null) return false;
            if (storageClass != null ? !storageClass.equals(that.storageClass) :that.storageClass != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (deleteClaim != that.deleteClaim) return false;
            if (overrides != null ? !overrides.equals(that.overrides) :that.overrides != null) return false;
            if (id != null ? !id.equals(that.id) :that.id != null) return false;
            return true;
    }


    public class OverridesNestedImpl<N> extends PersistentClaimStorageOverrideFluentImpl<PersistentClaimStorageFluent.OverridesNested<N>> implements PersistentClaimStorageFluent.OverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentClaimStorageOverrideBuilder builder;
        private final int index;
    
            OverridesNestedImpl(int index,PersistentClaimStorageOverride item){
                    this.index = index;
                    this.builder = new PersistentClaimStorageOverrideBuilder(this, item);
            }
            OverridesNestedImpl(){
                    this.index = -1;
                    this.builder = new PersistentClaimStorageOverrideBuilder(this);
            }
    
    public N and(){
            return (N) PersistentClaimStorageFluentImpl.this.setToOverrides(index, builder.build());
    }
    public N endOverride(){
            return and();
    }

}


}
