package io.strimzi.api.kafka.model.storage;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class PersistentClaimStorageOverrideFluentImpl<A extends PersistentClaimStorageOverrideFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PersistentClaimStorageOverrideFluent<A>{

    private Integer broker;
    private String storageClass;

    public PersistentClaimStorageOverrideFluentImpl(){
    }
    public PersistentClaimStorageOverrideFluentImpl(PersistentClaimStorageOverride instance){
            this.withBroker(instance.getBroker());

            this.withStorageClass(instance.getStorageClass());

    }

    public Integer getBroker(){
            return this.broker;
    }

    public A withBroker(Integer broker){
            this.broker=broker; return (A) this;
    }

    public Boolean hasBroker(){
            return this.broker != null;
    }

    public String getStorageClass(){
            return this.storageClass;
    }

    public A withStorageClass(String storageClass){
            this.storageClass=storageClass; return (A) this;
    }

    public Boolean hasStorageClass(){
            return this.storageClass != null;
    }

    public A withNewStorageClass(String arg1){
            return (A)withStorageClass(new String(arg1));
    }

    public A withNewStorageClass(StringBuilder arg1){
            return (A)withStorageClass(new String(arg1));
    }

    public A withNewStorageClass(StringBuffer arg1){
            return (A)withStorageClass(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PersistentClaimStorageOverrideFluentImpl that = (PersistentClaimStorageOverrideFluentImpl) o;
            if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
            if (storageClass != null ? !storageClass.equals(that.storageClass) :that.storageClass != null) return false;
            return true;
    }




}
