package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class CruiseControlTemplateFluentImpl<A extends CruiseControlTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CruiseControlTemplateFluent<A>{

    private ResourceTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private ResourceTemplateBuilder apiService;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder cruiseControlContainer;
    private ContainerTemplateBuilder tlsSidecarContainer;

    public CruiseControlTemplateFluentImpl(){
    }
    public CruiseControlTemplateFluentImpl(CruiseControlTemplate instance){
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withApiService(instance.getApiService());

            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());

            this.withCruiseControlContainer(instance.getCruiseControlContainer());

            this.withTlsSidecarContainer(instance.getTlsSidecarContainer());

    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public ResourceTemplate buildDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(ResourceTemplate deployment){
            _visitables.get("deployment").remove(this.deployment);
            if (deployment!=null){ this.deployment= new ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment(){
            return this.deployment != null;
    }

    public CruiseControlTemplateFluent.DeploymentNested<A> withNewDeployment(){
            return new DeploymentNestedImpl();
    }

    public CruiseControlTemplateFluent.DeploymentNested<A> withNewDeploymentLike(ResourceTemplate item){
            return new DeploymentNestedImpl(item);
    }

    public CruiseControlTemplateFluent.DeploymentNested<A> editDeployment(){
            return withNewDeploymentLike(getDeployment());
    }

    public CruiseControlTemplateFluent.DeploymentNested<A> editOrNewDeployment(){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new ResourceTemplateBuilder().build());
    }

    public CruiseControlTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(ResourceTemplate item){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod){
            _visitables.get("pod").remove(this.pod);
            if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod(){
            return this.pod != null;
    }

    public CruiseControlTemplateFluent.PodNested<A> withNewPod(){
            return new PodNestedImpl();
    }

    public CruiseControlTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item){
            return new PodNestedImpl(item);
    }

    public CruiseControlTemplateFluent.PodNested<A> editPod(){
            return withNewPodLike(getPod());
    }

    public CruiseControlTemplateFluent.PodNested<A> editOrNewPod(){
            return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public CruiseControlTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item){
            return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildApiService instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public ResourceTemplate buildApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(ResourceTemplate apiService){
            _visitables.get("apiService").remove(this.apiService);
            if (apiService!=null){ this.apiService= new ResourceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public Boolean hasApiService(){
            return this.apiService != null;
    }

    public CruiseControlTemplateFluent.ApiServiceNested<A> withNewApiService(){
            return new ApiServiceNestedImpl();
    }

    public CruiseControlTemplateFluent.ApiServiceNested<A> withNewApiServiceLike(ResourceTemplate item){
            return new ApiServiceNestedImpl(item);
    }

    public CruiseControlTemplateFluent.ApiServiceNested<A> editApiService(){
            return withNewApiServiceLike(getApiService());
    }

    public CruiseControlTemplateFluent.ApiServiceNested<A> editOrNewApiService(){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): new ResourceTemplateBuilder().build());
    }

    public CruiseControlTemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(ResourceTemplate item){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodDisruptionBudget instead.
 * @return The buildable object.
 */
@Deprecated public PodDisruptionBudgetTemplate getPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget){
            _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
            if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public Boolean hasPodDisruptionBudget(){
            return this.podDisruptionBudget != null;
    }

    public CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget(){
            return new PodDisruptionBudgetNestedImpl();
    }

    public CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return new PodDisruptionBudgetNestedImpl(item);
    }

    public CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new PodDisruptionBudgetTemplateBuilder().build());
    }

    public CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCruiseControlContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getCruiseControlContainer(){
            return this.cruiseControlContainer!=null?this.cruiseControlContainer.build():null;
    }

    public ContainerTemplate buildCruiseControlContainer(){
            return this.cruiseControlContainer!=null?this.cruiseControlContainer.build():null;
    }

    public A withCruiseControlContainer(ContainerTemplate cruiseControlContainer){
            _visitables.get("cruiseControlContainer").remove(this.cruiseControlContainer);
            if (cruiseControlContainer!=null){ this.cruiseControlContainer= new ContainerTemplateBuilder(cruiseControlContainer); _visitables.get("cruiseControlContainer").add(this.cruiseControlContainer);} return (A) this;
    }

    public Boolean hasCruiseControlContainer(){
            return this.cruiseControlContainer != null;
    }

    public CruiseControlTemplateFluent.CruiseControlContainerNested<A> withNewCruiseControlContainer(){
            return new CruiseControlContainerNestedImpl();
    }

    public CruiseControlTemplateFluent.CruiseControlContainerNested<A> withNewCruiseControlContainerLike(ContainerTemplate item){
            return new CruiseControlContainerNestedImpl(item);
    }

    public CruiseControlTemplateFluent.CruiseControlContainerNested<A> editCruiseControlContainer(){
            return withNewCruiseControlContainerLike(getCruiseControlContainer());
    }

    public CruiseControlTemplateFluent.CruiseControlContainerNested<A> editOrNewCruiseControlContainer(){
            return withNewCruiseControlContainerLike(getCruiseControlContainer() != null ? getCruiseControlContainer(): new ContainerTemplateBuilder().build());
    }

    public CruiseControlTemplateFluent.CruiseControlContainerNested<A> editOrNewCruiseControlContainerLike(ContainerTemplate item){
            return withNewCruiseControlContainerLike(getCruiseControlContainer() != null ? getCruiseControlContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSidecarContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getTlsSidecarContainer(){
            return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public ContainerTemplate buildTlsSidecarContainer(){
            return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public A withTlsSidecarContainer(ContainerTemplate tlsSidecarContainer){
            _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer);
            if (tlsSidecarContainer!=null){ this.tlsSidecarContainer= new ContainerTemplateBuilder(tlsSidecarContainer); _visitables.get("tlsSidecarContainer").add(this.tlsSidecarContainer);} return (A) this;
    }

    public Boolean hasTlsSidecarContainer(){
            return this.tlsSidecarContainer != null;
    }

    public CruiseControlTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainer(){
            return new TlsSidecarContainerNestedImpl();
    }

    public CruiseControlTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(ContainerTemplate item){
            return new TlsSidecarContainerNestedImpl(item);
    }

    public CruiseControlTemplateFluent.TlsSidecarContainerNested<A> editTlsSidecarContainer(){
            return withNewTlsSidecarContainerLike(getTlsSidecarContainer());
    }

    public CruiseControlTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer(){
            return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): new ContainerTemplateBuilder().build());
    }

    public CruiseControlTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(ContainerTemplate item){
            return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CruiseControlTemplateFluentImpl that = (CruiseControlTemplateFluentImpl) o;
            if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
            if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
            if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
            if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
            if (cruiseControlContainer != null ? !cruiseControlContainer.equals(that.cruiseControlContainer) :that.cruiseControlContainer != null) return false;
            if (tlsSidecarContainer != null ? !tlsSidecarContainer.equals(that.tlsSidecarContainer) :that.tlsSidecarContainer != null) return false;
            return true;
    }


    public class DeploymentNestedImpl<N> extends ResourceTemplateFluentImpl<CruiseControlTemplateFluent.DeploymentNested<N>> implements CruiseControlTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            DeploymentNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            DeploymentNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) CruiseControlTemplateFluentImpl.this.withDeployment(builder.build());
    }
    public N endDeployment(){
            return and();
    }

}
    public class PodNestedImpl<N> extends PodTemplateFluentImpl<CruiseControlTemplateFluent.PodNested<N>> implements CruiseControlTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) CruiseControlTemplateFluentImpl.this.withPod(builder.build());
    }
    public N endPod(){
            return and();
    }

}
    public class ApiServiceNestedImpl<N> extends ResourceTemplateFluentImpl<CruiseControlTemplateFluent.ApiServiceNested<N>> implements CruiseControlTemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            ApiServiceNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            ApiServiceNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) CruiseControlTemplateFluentImpl.this.withApiService(builder.build());
    }
    public N endApiService(){
            return and();
    }

}
    public class PodDisruptionBudgetNestedImpl<N> extends PodDisruptionBudgetTemplateFluentImpl<CruiseControlTemplateFluent.PodDisruptionBudgetNested<N>> implements CruiseControlTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodDisruptionBudgetTemplateBuilder builder;
    
            PodDisruptionBudgetNestedImpl(PodDisruptionBudgetTemplate item){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
            }
            PodDisruptionBudgetNestedImpl(){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this);
            }
    
    public N and(){
            return (N) CruiseControlTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget(){
            return and();
    }

}
    public class CruiseControlContainerNestedImpl<N> extends ContainerTemplateFluentImpl<CruiseControlTemplateFluent.CruiseControlContainerNested<N>> implements CruiseControlTemplateFluent.CruiseControlContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            CruiseControlContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            CruiseControlContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) CruiseControlTemplateFluentImpl.this.withCruiseControlContainer(builder.build());
    }
    public N endCruiseControlContainer(){
            return and();
    }

}
    public class TlsSidecarContainerNestedImpl<N> extends ContainerTemplateFluentImpl<CruiseControlTemplateFluent.TlsSidecarContainerNested<N>> implements CruiseControlTemplateFluent.TlsSidecarContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            TlsSidecarContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            TlsSidecarContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) CruiseControlTemplateFluentImpl.this.withTlsSidecarContainer(builder.build());
    }
    public N endTlsSidecarContainer(){
            return and();
    }

}


}
