package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DeploymentTemplateBuilder extends DeploymentTemplateFluentImpl<DeploymentTemplateBuilder> implements VisitableBuilder<DeploymentTemplate,DeploymentTemplateBuilder>{

    DeploymentTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentTemplateBuilder(){
            this(true);
    }
    public DeploymentTemplateBuilder(Boolean validationEnabled){
            this(new DeploymentTemplate(), validationEnabled);
    }
    public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DeploymentTemplate(), validationEnabled);
    }
    public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent,DeploymentTemplate instance){
            this(fluent, instance, true);
    }
    public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent,DeploymentTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata());

            fluent.withDeploymentStrategy(instance.getDeploymentStrategy());

            this.validationEnabled = validationEnabled; 
    }
    public DeploymentTemplateBuilder(DeploymentTemplate instance){
            this(instance,true);
    }
    public DeploymentTemplateBuilder(DeploymentTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata());

            this.withDeploymentStrategy(instance.getDeploymentStrategy());

            this.validationEnabled = validationEnabled; 
    }

    public DeploymentTemplate build(){
            DeploymentTemplate buildable = new DeploymentTemplate();
            buildable.setMetadata(fluent.getMetadata());
            buildable.setDeploymentStrategy(fluent.getDeploymentStrategy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentTemplateBuilder that = (DeploymentTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
