package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JmxTransQueryTemplateBuilder extends JmxTransQueryTemplateFluentImpl<JmxTransQueryTemplateBuilder> implements VisitableBuilder<JmxTransQueryTemplate,JmxTransQueryTemplateBuilder>{

    JmxTransQueryTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public JmxTransQueryTemplateBuilder(){
            this(true);
    }
    public JmxTransQueryTemplateBuilder(Boolean validationEnabled){
            this(new JmxTransQueryTemplate(), validationEnabled);
    }
    public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JmxTransQueryTemplate(), validationEnabled);
    }
    public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent,JmxTransQueryTemplate instance){
            this(fluent, instance, true);
    }
    public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent,JmxTransQueryTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTargetMBean(instance.getTargetMBean());

            fluent.withAttributes(instance.getAttributes());

            fluent.withOutputs(instance.getOutputs());

            this.validationEnabled = validationEnabled; 
    }
    public JmxTransQueryTemplateBuilder(JmxTransQueryTemplate instance){
            this(instance,true);
    }
    public JmxTransQueryTemplateBuilder(JmxTransQueryTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTargetMBean(instance.getTargetMBean());

            this.withAttributes(instance.getAttributes());

            this.withOutputs(instance.getOutputs());

            this.validationEnabled = validationEnabled; 
    }

    public JmxTransQueryTemplate build(){
            JmxTransQueryTemplate buildable = new JmxTransQueryTemplate();
            buildable.setTargetMBean(fluent.getTargetMBean());
            buildable.setAttributes(fluent.getAttributes());
            buildable.setOutputs(fluent.getOutputs());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JmxTransQueryTemplateBuilder that = (JmxTransQueryTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
