package io.strimzi.api.kafka.model.template;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class JmxTransQueryTemplateFluentImpl<A extends JmxTransQueryTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JmxTransQueryTemplateFluent<A>{

    private String targetMBean;
    private java.util.List<String> attributes;
    private java.util.List<String> outputs;

    public JmxTransQueryTemplateFluentImpl(){
    }
    public JmxTransQueryTemplateFluentImpl(JmxTransQueryTemplate instance){
            this.withTargetMBean(instance.getTargetMBean());

            this.withAttributes(instance.getAttributes());

            this.withOutputs(instance.getOutputs());

    }

    public String getTargetMBean(){
            return this.targetMBean;
    }

    public A withTargetMBean(String targetMBean){
            this.targetMBean=targetMBean; return (A) this;
    }

    public Boolean hasTargetMBean(){
            return this.targetMBean != null;
    }

    public A withNewTargetMBean(String arg1){
            return (A)withTargetMBean(new String(arg1));
    }

    public A withNewTargetMBean(StringBuilder arg1){
            return (A)withTargetMBean(new String(arg1));
    }

    public A withNewTargetMBean(StringBuffer arg1){
            return (A)withTargetMBean(new String(arg1));
    }

    public A addToAttributes(int index,String item){
            if (this.attributes == null) {this.attributes = new ArrayList<String>();}
            this.attributes.add(index, item);
            return (A)this;
    }

    public A setToAttributes(int index,String item){
            if (this.attributes == null) {this.attributes = new ArrayList<String>();}
            this.attributes.set(index, item); return (A)this;
    }

    public A addToAttributes(String... items){
            if (this.attributes == null) {this.attributes = new ArrayList<String>();}
            for (String item : items) {this.attributes.add(item);} return (A)this;
    }

    public A addAllToAttributes(Collection<String> items){
            if (this.attributes == null) {this.attributes = new ArrayList<String>();}
            for (String item : items) {this.attributes.add(item);} return (A)this;
    }

    public A removeFromAttributes(String... items){
            for (String item : items) {if (this.attributes!= null){ this.attributes.remove(item);}} return (A)this;
    }

    public A removeAllFromAttributes(Collection<String> items){
            for (String item : items) {if (this.attributes!= null){ this.attributes.remove(item);}} return (A)this;
    }

    public java.util.List<String> getAttributes(){
            return this.attributes;
    }

    public String getAttribute(int index){
            return this.attributes.get(index);
    }

    public String getFirstAttribute(){
            return this.attributes.get(0);
    }

    public String getLastAttribute(){
            return this.attributes.get(attributes.size() - 1);
    }

    public String getMatchingAttribute(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: attributes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAttribute(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: attributes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAttributes(java.util.List<String> attributes){
            if (this.attributes != null) { _visitables.get("attributes").removeAll(this.attributes);}
            if (attributes != null) {this.attributes = new ArrayList<String>(); for (String item : attributes){this.addToAttributes(item);}} else { this.attributes = null;} return (A) this;
    }

    public A withAttributes(String... attributes){
            if (this.attributes != null) {this.attributes.clear();}
            if (attributes != null) {for (String item :attributes){ this.addToAttributes(item);}} return (A) this;
    }

    public Boolean hasAttributes(){
            return attributes != null && !attributes.isEmpty();
    }

    public A addNewAttribute(String arg1){
            return (A)addToAttributes(new String(arg1));
    }

    public A addNewAttribute(StringBuilder arg1){
            return (A)addToAttributes(new String(arg1));
    }

    public A addNewAttribute(StringBuffer arg1){
            return (A)addToAttributes(new String(arg1));
    }

    public A addToOutputs(int index,String item){
            if (this.outputs == null) {this.outputs = new ArrayList<String>();}
            this.outputs.add(index, item);
            return (A)this;
    }

    public A setToOutputs(int index,String item){
            if (this.outputs == null) {this.outputs = new ArrayList<String>();}
            this.outputs.set(index, item); return (A)this;
    }

    public A addToOutputs(String... items){
            if (this.outputs == null) {this.outputs = new ArrayList<String>();}
            for (String item : items) {this.outputs.add(item);} return (A)this;
    }

    public A addAllToOutputs(Collection<String> items){
            if (this.outputs == null) {this.outputs = new ArrayList<String>();}
            for (String item : items) {this.outputs.add(item);} return (A)this;
    }

    public A removeFromOutputs(String... items){
            for (String item : items) {if (this.outputs!= null){ this.outputs.remove(item);}} return (A)this;
    }

    public A removeAllFromOutputs(Collection<String> items){
            for (String item : items) {if (this.outputs!= null){ this.outputs.remove(item);}} return (A)this;
    }

    public java.util.List<String> getOutputs(){
            return this.outputs;
    }

    public String getOutput(int index){
            return this.outputs.get(index);
    }

    public String getFirstOutput(){
            return this.outputs.get(0);
    }

    public String getLastOutput(){
            return this.outputs.get(outputs.size() - 1);
    }

    public String getMatchingOutput(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: outputs) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingOutput(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: outputs) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withOutputs(java.util.List<String> outputs){
            if (this.outputs != null) { _visitables.get("outputs").removeAll(this.outputs);}
            if (outputs != null) {this.outputs = new ArrayList<String>(); for (String item : outputs){this.addToOutputs(item);}} else { this.outputs = null;} return (A) this;
    }

    public A withOutputs(String... outputs){
            if (this.outputs != null) {this.outputs.clear();}
            if (outputs != null) {for (String item :outputs){ this.addToOutputs(item);}} return (A) this;
    }

    public Boolean hasOutputs(){
            return outputs != null && !outputs.isEmpty();
    }

    public A addNewOutput(String arg1){
            return (A)addToOutputs(new String(arg1));
    }

    public A addNewOutput(StringBuilder arg1){
            return (A)addToOutputs(new String(arg1));
    }

    public A addNewOutput(StringBuffer arg1){
            return (A)addToOutputs(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            JmxTransQueryTemplateFluentImpl that = (JmxTransQueryTemplateFluentImpl) o;
            if (targetMBean != null ? !targetMBean.equals(that.targetMBean) :that.targetMBean != null) return false;
            if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
            if (outputs != null ? !outputs.equals(that.outputs) :that.outputs != null) return false;
            return true;
    }




}
