package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JmxTransTemplateBuilder extends JmxTransTemplateFluentImpl<JmxTransTemplateBuilder> implements VisitableBuilder<JmxTransTemplate,JmxTransTemplateBuilder>{

    JmxTransTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public JmxTransTemplateBuilder(){
            this(true);
    }
    public JmxTransTemplateBuilder(Boolean validationEnabled){
            this(new JmxTransTemplate(), validationEnabled);
    }
    public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JmxTransTemplate(), validationEnabled);
    }
    public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent,JmxTransTemplate instance){
            this(fluent, instance, true);
    }
    public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent,JmxTransTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDeployment(instance.getDeployment());

            fluent.withPod(instance.getPod());

            fluent.withContainer(instance.getContainer());

            this.validationEnabled = validationEnabled; 
    }
    public JmxTransTemplateBuilder(JmxTransTemplate instance){
            this(instance,true);
    }
    public JmxTransTemplateBuilder(JmxTransTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withContainer(instance.getContainer());

            this.validationEnabled = validationEnabled; 
    }

    public JmxTransTemplate build(){
            JmxTransTemplate buildable = new JmxTransTemplate();
            buildable.setDeployment(fluent.getDeployment());
            buildable.setPod(fluent.getPod());
            buildable.setContainer(fluent.getContainer());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JmxTransTemplateBuilder that = (JmxTransTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
