package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class JmxTransTemplateFluentImpl<A extends JmxTransTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JmxTransTemplateFluent<A>{

    private ResourceTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private ContainerTemplateBuilder container;

    public JmxTransTemplateFluentImpl(){
    }
    public JmxTransTemplateFluentImpl(JmxTransTemplate instance){
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withContainer(instance.getContainer());

    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public ResourceTemplate buildDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(ResourceTemplate deployment){
            _visitables.get("deployment").remove(this.deployment);
            if (deployment!=null){ this.deployment= new ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment(){
            return this.deployment != null;
    }

    public JmxTransTemplateFluent.DeploymentNested<A> withNewDeployment(){
            return new DeploymentNestedImpl();
    }

    public JmxTransTemplateFluent.DeploymentNested<A> withNewDeploymentLike(ResourceTemplate item){
            return new DeploymentNestedImpl(item);
    }

    public JmxTransTemplateFluent.DeploymentNested<A> editDeployment(){
            return withNewDeploymentLike(getDeployment());
    }

    public JmxTransTemplateFluent.DeploymentNested<A> editOrNewDeployment(){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new ResourceTemplateBuilder().build());
    }

    public JmxTransTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(ResourceTemplate item){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod){
            _visitables.get("pod").remove(this.pod);
            if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod(){
            return this.pod != null;
    }

    public JmxTransTemplateFluent.PodNested<A> withNewPod(){
            return new PodNestedImpl();
    }

    public JmxTransTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item){
            return new PodNestedImpl(item);
    }

    public JmxTransTemplateFluent.PodNested<A> editPod(){
            return withNewPodLike(getPod());
    }

    public JmxTransTemplateFluent.PodNested<A> editOrNewPod(){
            return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public JmxTransTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item){
            return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getContainer(){
            return this.container!=null?this.container.build():null;
    }

    public ContainerTemplate buildContainer(){
            return this.container!=null?this.container.build():null;
    }

    public A withContainer(ContainerTemplate container){
            _visitables.get("container").remove(this.container);
            if (container!=null){ this.container= new ContainerTemplateBuilder(container); _visitables.get("container").add(this.container);} return (A) this;
    }

    public Boolean hasContainer(){
            return this.container != null;
    }

    public JmxTransTemplateFluent.ContainerNested<A> withNewContainer(){
            return new ContainerNestedImpl();
    }

    public JmxTransTemplateFluent.ContainerNested<A> withNewContainerLike(ContainerTemplate item){
            return new ContainerNestedImpl(item);
    }

    public JmxTransTemplateFluent.ContainerNested<A> editContainer(){
            return withNewContainerLike(getContainer());
    }

    public JmxTransTemplateFluent.ContainerNested<A> editOrNewContainer(){
            return withNewContainerLike(getContainer() != null ? getContainer(): new ContainerTemplateBuilder().build());
    }

    public JmxTransTemplateFluent.ContainerNested<A> editOrNewContainerLike(ContainerTemplate item){
            return withNewContainerLike(getContainer() != null ? getContainer(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            JmxTransTemplateFluentImpl that = (JmxTransTemplateFluentImpl) o;
            if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
            if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
            if (container != null ? !container.equals(that.container) :that.container != null) return false;
            return true;
    }


    public class DeploymentNestedImpl<N> extends ResourceTemplateFluentImpl<JmxTransTemplateFluent.DeploymentNested<N>> implements JmxTransTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            DeploymentNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            DeploymentNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) JmxTransTemplateFluentImpl.this.withDeployment(builder.build());
    }
    public N endDeployment(){
            return and();
    }

}
    public class PodNestedImpl<N> extends PodTemplateFluentImpl<JmxTransTemplateFluent.PodNested<N>> implements JmxTransTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) JmxTransTemplateFluentImpl.this.withPod(builder.build());
    }
    public N endPod(){
            return and();
    }

}
    public class ContainerNestedImpl<N> extends ContainerTemplateFluentImpl<JmxTransTemplateFluent.ContainerNested<N>> implements JmxTransTemplateFluent.ContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            ContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            ContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) JmxTransTemplateFluentImpl.this.withContainer(builder.build());
    }
    public N endContainer(){
            return and();
    }

}


}
