package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class KafkaConnectTemplateFluentImpl<A extends KafkaConnectTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaConnectTemplateFluent<A>{

    private DeploymentTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private PodTemplateBuilder buildPod;
    private ResourceTemplateBuilder apiService;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder connectContainer;
    private ContainerTemplateBuilder initContainer;
    private ContainerTemplateBuilder buildContainer;
    private ResourceTemplateBuilder buildConfig;

    public KafkaConnectTemplateFluentImpl(){
    }
    public KafkaConnectTemplateFluentImpl(KafkaConnectTemplate instance){
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withBuildPod(instance.getBuildPod());

            this.withApiService(instance.getApiService());

            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());

            this.withConnectContainer(instance.getConnectContainer());

            this.withInitContainer(instance.getInitContainer());

            this.withBuildContainer(instance.getBuildContainer());

            this.withBuildConfig(instance.getBuildConfig());

    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentTemplate getDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public DeploymentTemplate buildDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(DeploymentTemplate deployment){
            _visitables.get("deployment").remove(this.deployment);
            if (deployment!=null){ this.deployment= new DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment(){
            return this.deployment != null;
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> withNewDeployment(){
            return new DeploymentNestedImpl();
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item){
            return new DeploymentNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> editDeployment(){
            return withNewDeploymentLike(getDeployment());
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> editOrNewDeployment(){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new DeploymentTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod){
            _visitables.get("pod").remove(this.pod);
            if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod(){
            return this.pod != null;
    }

    public KafkaConnectTemplateFluent.PodNested<A> withNewPod(){
            return new PodNestedImpl();
    }

    public KafkaConnectTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item){
            return new PodNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.PodNested<A> editPod(){
            return withNewPodLike(getPod());
    }

    public KafkaConnectTemplateFluent.PodNested<A> editOrNewPod(){
            return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item){
            return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBuildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getBuildPod(){
            return this.buildPod!=null?this.buildPod.build():null;
    }

    public PodTemplate buildBuildPod(){
            return this.buildPod!=null?this.buildPod.build():null;
    }

    public A withBuildPod(PodTemplate buildPod){
            _visitables.get("buildPod").remove(this.buildPod);
            if (buildPod!=null){ this.buildPod= new PodTemplateBuilder(buildPod); _visitables.get("buildPod").add(this.buildPod);} return (A) this;
    }

    public Boolean hasBuildPod(){
            return this.buildPod != null;
    }

    public KafkaConnectTemplateFluent.BuildPodNested<A> withNewBuildPod(){
            return new BuildPodNestedImpl();
    }

    public KafkaConnectTemplateFluent.BuildPodNested<A> withNewBuildPodLike(PodTemplate item){
            return new BuildPodNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.BuildPodNested<A> editBuildPod(){
            return withNewBuildPodLike(getBuildPod());
    }

    public KafkaConnectTemplateFluent.BuildPodNested<A> editOrNewBuildPod(){
            return withNewBuildPodLike(getBuildPod() != null ? getBuildPod(): new PodTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.BuildPodNested<A> editOrNewBuildPodLike(PodTemplate item){
            return withNewBuildPodLike(getBuildPod() != null ? getBuildPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildApiService instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public ResourceTemplate buildApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(ResourceTemplate apiService){
            _visitables.get("apiService").remove(this.apiService);
            if (apiService!=null){ this.apiService= new ResourceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public Boolean hasApiService(){
            return this.apiService != null;
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> withNewApiService(){
            return new ApiServiceNestedImpl();
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> withNewApiServiceLike(ResourceTemplate item){
            return new ApiServiceNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> editApiService(){
            return withNewApiServiceLike(getApiService());
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> editOrNewApiService(){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): new ResourceTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(ResourceTemplate item){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodDisruptionBudget instead.
 * @return The buildable object.
 */
@Deprecated public PodDisruptionBudgetTemplate getPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget){
            _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
            if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public Boolean hasPodDisruptionBudget(){
            return this.podDisruptionBudget != null;
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget(){
            return new PodDisruptionBudgetNestedImpl();
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return new PodDisruptionBudgetNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new PodDisruptionBudgetTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConnectContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getConnectContainer(){
            return this.connectContainer!=null?this.connectContainer.build():null;
    }

    public ContainerTemplate buildConnectContainer(){
            return this.connectContainer!=null?this.connectContainer.build():null;
    }

    public A withConnectContainer(ContainerTemplate connectContainer){
            _visitables.get("connectContainer").remove(this.connectContainer);
            if (connectContainer!=null){ this.connectContainer= new ContainerTemplateBuilder(connectContainer); _visitables.get("connectContainer").add(this.connectContainer);} return (A) this;
    }

    public Boolean hasConnectContainer(){
            return this.connectContainer != null;
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> withNewConnectContainer(){
            return new ConnectContainerNestedImpl();
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> withNewConnectContainerLike(ContainerTemplate item){
            return new ConnectContainerNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> editConnectContainer(){
            return withNewConnectContainerLike(getConnectContainer());
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> editOrNewConnectContainer(){
            return withNewConnectContainerLike(getConnectContainer() != null ? getConnectContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.ConnectContainerNested<A> editOrNewConnectContainerLike(ContainerTemplate item){
            return withNewConnectContainerLike(getConnectContainer() != null ? getConnectContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildInitContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getInitContainer(){
            return this.initContainer!=null?this.initContainer.build():null;
    }

    public ContainerTemplate buildInitContainer(){
            return this.initContainer!=null?this.initContainer.build():null;
    }

    public A withInitContainer(ContainerTemplate initContainer){
            _visitables.get("initContainer").remove(this.initContainer);
            if (initContainer!=null){ this.initContainer= new ContainerTemplateBuilder(initContainer); _visitables.get("initContainer").add(this.initContainer);} return (A) this;
    }

    public Boolean hasInitContainer(){
            return this.initContainer != null;
    }

    public KafkaConnectTemplateFluent.InitContainerNested<A> withNewInitContainer(){
            return new InitContainerNestedImpl();
    }

    public KafkaConnectTemplateFluent.InitContainerNested<A> withNewInitContainerLike(ContainerTemplate item){
            return new InitContainerNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.InitContainerNested<A> editInitContainer(){
            return withNewInitContainerLike(getInitContainer());
    }

    public KafkaConnectTemplateFluent.InitContainerNested<A> editOrNewInitContainer(){
            return withNewInitContainerLike(getInitContainer() != null ? getInitContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.InitContainerNested<A> editOrNewInitContainerLike(ContainerTemplate item){
            return withNewInitContainerLike(getInitContainer() != null ? getInitContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBuildContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getBuildContainer(){
            return this.buildContainer!=null?this.buildContainer.build():null;
    }

    public ContainerTemplate buildBuildContainer(){
            return this.buildContainer!=null?this.buildContainer.build():null;
    }

    public A withBuildContainer(ContainerTemplate buildContainer){
            _visitables.get("buildContainer").remove(this.buildContainer);
            if (buildContainer!=null){ this.buildContainer= new ContainerTemplateBuilder(buildContainer); _visitables.get("buildContainer").add(this.buildContainer);} return (A) this;
    }

    public Boolean hasBuildContainer(){
            return this.buildContainer != null;
    }

    public KafkaConnectTemplateFluent.BuildContainerNested<A> withNewBuildContainer(){
            return new BuildContainerNestedImpl();
    }

    public KafkaConnectTemplateFluent.BuildContainerNested<A> withNewBuildContainerLike(ContainerTemplate item){
            return new BuildContainerNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.BuildContainerNested<A> editBuildContainer(){
            return withNewBuildContainerLike(getBuildContainer());
    }

    public KafkaConnectTemplateFluent.BuildContainerNested<A> editOrNewBuildContainer(){
            return withNewBuildContainerLike(getBuildContainer() != null ? getBuildContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.BuildContainerNested<A> editOrNewBuildContainerLike(ContainerTemplate item){
            return withNewBuildContainerLike(getBuildContainer() != null ? getBuildContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBuildConfig instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getBuildConfig(){
            return this.buildConfig!=null?this.buildConfig.build():null;
    }

    public ResourceTemplate buildBuildConfig(){
            return this.buildConfig!=null?this.buildConfig.build():null;
    }

    public A withBuildConfig(ResourceTemplate buildConfig){
            _visitables.get("buildConfig").remove(this.buildConfig);
            if (buildConfig!=null){ this.buildConfig= new ResourceTemplateBuilder(buildConfig); _visitables.get("buildConfig").add(this.buildConfig);} return (A) this;
    }

    public Boolean hasBuildConfig(){
            return this.buildConfig != null;
    }

    public KafkaConnectTemplateFluent.BuildConfigNested<A> withNewBuildConfig(){
            return new BuildConfigNestedImpl();
    }

    public KafkaConnectTemplateFluent.BuildConfigNested<A> withNewBuildConfigLike(ResourceTemplate item){
            return new BuildConfigNestedImpl(item);
    }

    public KafkaConnectTemplateFluent.BuildConfigNested<A> editBuildConfig(){
            return withNewBuildConfigLike(getBuildConfig());
    }

    public KafkaConnectTemplateFluent.BuildConfigNested<A> editOrNewBuildConfig(){
            return withNewBuildConfigLike(getBuildConfig() != null ? getBuildConfig(): new ResourceTemplateBuilder().build());
    }

    public KafkaConnectTemplateFluent.BuildConfigNested<A> editOrNewBuildConfigLike(ResourceTemplate item){
            return withNewBuildConfigLike(getBuildConfig() != null ? getBuildConfig(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaConnectTemplateFluentImpl that = (KafkaConnectTemplateFluentImpl) o;
            if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
            if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
            if (buildPod != null ? !buildPod.equals(that.buildPod) :that.buildPod != null) return false;
            if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
            if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
            if (connectContainer != null ? !connectContainer.equals(that.connectContainer) :that.connectContainer != null) return false;
            if (initContainer != null ? !initContainer.equals(that.initContainer) :that.initContainer != null) return false;
            if (buildContainer != null ? !buildContainer.equals(that.buildContainer) :that.buildContainer != null) return false;
            if (buildConfig != null ? !buildConfig.equals(that.buildConfig) :that.buildConfig != null) return false;
            return true;
    }


    public class DeploymentNestedImpl<N> extends DeploymentTemplateFluentImpl<KafkaConnectTemplateFluent.DeploymentNested<N>> implements KafkaConnectTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentTemplateBuilder builder;
    
            DeploymentNestedImpl(DeploymentTemplate item){
                    this.builder = new DeploymentTemplateBuilder(this, item);
            }
            DeploymentNestedImpl(){
                    this.builder = new DeploymentTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withDeployment(builder.build());
    }
    public N endDeployment(){
            return and();
    }

}
    public class PodNestedImpl<N> extends PodTemplateFluentImpl<KafkaConnectTemplateFluent.PodNested<N>> implements KafkaConnectTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withPod(builder.build());
    }
    public N endPod(){
            return and();
    }

}
    public class BuildPodNestedImpl<N> extends PodTemplateFluentImpl<KafkaConnectTemplateFluent.BuildPodNested<N>> implements KafkaConnectTemplateFluent.BuildPodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            BuildPodNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            BuildPodNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withBuildPod(builder.build());
    }
    public N endBuildPod(){
            return and();
    }

}
    public class ApiServiceNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaConnectTemplateFluent.ApiServiceNested<N>> implements KafkaConnectTemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            ApiServiceNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            ApiServiceNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withApiService(builder.build());
    }
    public N endApiService(){
            return and();
    }

}
    public class PodDisruptionBudgetNestedImpl<N> extends PodDisruptionBudgetTemplateFluentImpl<KafkaConnectTemplateFluent.PodDisruptionBudgetNested<N>> implements KafkaConnectTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodDisruptionBudgetTemplateBuilder builder;
    
            PodDisruptionBudgetNestedImpl(PodDisruptionBudgetTemplate item){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
            }
            PodDisruptionBudgetNestedImpl(){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget(){
            return and();
    }

}
    public class ConnectContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaConnectTemplateFluent.ConnectContainerNested<N>> implements KafkaConnectTemplateFluent.ConnectContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            ConnectContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            ConnectContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withConnectContainer(builder.build());
    }
    public N endConnectContainer(){
            return and();
    }

}
    public class InitContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaConnectTemplateFluent.InitContainerNested<N>> implements KafkaConnectTemplateFluent.InitContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            InitContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            InitContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withInitContainer(builder.build());
    }
    public N endInitContainer(){
            return and();
    }

}
    public class BuildContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaConnectTemplateFluent.BuildContainerNested<N>> implements KafkaConnectTemplateFluent.BuildContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            BuildContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            BuildContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withBuildContainer(builder.build());
    }
    public N endBuildContainer(){
            return and();
    }

}
    public class BuildConfigNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaConnectTemplateFluent.BuildConfigNested<N>> implements KafkaConnectTemplateFluent.BuildConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            BuildConfigNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            BuildConfigNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectTemplateFluentImpl.this.withBuildConfig(builder.build());
    }
    public N endBuildConfig(){
            return and();
    }

}


}
