package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaExporterTemplateBuilder extends KafkaExporterTemplateFluentImpl<KafkaExporterTemplateBuilder> implements VisitableBuilder<KafkaExporterTemplate,KafkaExporterTemplateBuilder>{

    KafkaExporterTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaExporterTemplateBuilder(){
            this(true);
    }
    public KafkaExporterTemplateBuilder(Boolean validationEnabled){
            this(new KafkaExporterTemplate(), validationEnabled);
    }
    public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaExporterTemplate(), validationEnabled);
    }
    public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent,KafkaExporterTemplate instance){
            this(fluent, instance, true);
    }
    public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent,KafkaExporterTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDeployment(instance.getDeployment());

            fluent.withPod(instance.getPod());

            fluent.withService(instance.getService());

            fluent.withContainer(instance.getContainer());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaExporterTemplateBuilder(KafkaExporterTemplate instance){
            this(instance,true);
    }
    public KafkaExporterTemplateBuilder(KafkaExporterTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withService(instance.getService());

            this.withContainer(instance.getContainer());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaExporterTemplate build(){
            KafkaExporterTemplate buildable = new KafkaExporterTemplate();
            buildable.setDeployment(fluent.getDeployment());
            buildable.setPod(fluent.getPod());
            buildable.setService(fluent.getService());
            buildable.setContainer(fluent.getContainer());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaExporterTemplateBuilder that = (KafkaExporterTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
