package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2TemplateBuilder extends KafkaMirrorMaker2TemplateFluentImpl<KafkaMirrorMaker2TemplateBuilder> implements VisitableBuilder<KafkaMirrorMaker2Template,KafkaMirrorMaker2TemplateBuilder>{

    KafkaMirrorMaker2TemplateFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMaker2TemplateBuilder(){
            this(true);
    }
    public KafkaMirrorMaker2TemplateBuilder(Boolean validationEnabled){
            this(new KafkaMirrorMaker2Template(), validationEnabled);
    }
    public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaMirrorMaker2Template(), validationEnabled);
    }
    public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent,KafkaMirrorMaker2Template instance){
            this(fluent, instance, true);
    }
    public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent,KafkaMirrorMaker2Template instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDeployment(instance.getDeployment());

            fluent.withPod(instance.getPod());

            fluent.withApiService(instance.getApiService());

            fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());

            fluent.withMirrorMaker2Container(instance.getMirrorMaker2Container());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2Template instance){
            this(instance,true);
    }
    public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2Template instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withApiService(instance.getApiService());

            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());

            this.withMirrorMaker2Container(instance.getMirrorMaker2Container());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2Template build(){
            KafkaMirrorMaker2Template buildable = new KafkaMirrorMaker2Template();
            buildable.setDeployment(fluent.getDeployment());
            buildable.setPod(fluent.getPod());
            buildable.setApiService(fluent.getApiService());
            buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
            buildable.setMirrorMaker2Container(fluent.getMirrorMaker2Container());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMaker2TemplateBuilder that = (KafkaMirrorMaker2TemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
