package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class KafkaMirrorMaker2TemplateFluentImpl<A extends KafkaMirrorMaker2TemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaMirrorMaker2TemplateFluent<A>{

    private DeploymentTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private ResourceTemplateBuilder apiService;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder mirrorMaker2Container;

    public KafkaMirrorMaker2TemplateFluentImpl(){
    }
    public KafkaMirrorMaker2TemplateFluentImpl(KafkaMirrorMaker2Template instance){
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withApiService(instance.getApiService());

            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());

            this.withMirrorMaker2Container(instance.getMirrorMaker2Container());

    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentTemplate getDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public DeploymentTemplate buildDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(DeploymentTemplate deployment){
            _visitables.get("deployment").remove(this.deployment);
            if (deployment!=null){ this.deployment= new DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment(){
            return this.deployment != null;
    }

    public KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> withNewDeployment(){
            return new DeploymentNestedImpl();
    }

    public KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item){
            return new DeploymentNestedImpl(item);
    }

    public KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> editDeployment(){
            return withNewDeploymentLike(getDeployment());
    }

    public KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> editOrNewDeployment(){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new DeploymentTemplateBuilder().build());
    }

    public KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod){
            _visitables.get("pod").remove(this.pod);
            if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod(){
            return this.pod != null;
    }

    public KafkaMirrorMaker2TemplateFluent.PodNested<A> withNewPod(){
            return new PodNestedImpl();
    }

    public KafkaMirrorMaker2TemplateFluent.PodNested<A> withNewPodLike(PodTemplate item){
            return new PodNestedImpl(item);
    }

    public KafkaMirrorMaker2TemplateFluent.PodNested<A> editPod(){
            return withNewPodLike(getPod());
    }

    public KafkaMirrorMaker2TemplateFluent.PodNested<A> editOrNewPod(){
            return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public KafkaMirrorMaker2TemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item){
            return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildApiService instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public ResourceTemplate buildApiService(){
            return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(ResourceTemplate apiService){
            _visitables.get("apiService").remove(this.apiService);
            if (apiService!=null){ this.apiService= new ResourceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public Boolean hasApiService(){
            return this.apiService != null;
    }

    public KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> withNewApiService(){
            return new ApiServiceNestedImpl();
    }

    public KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> withNewApiServiceLike(ResourceTemplate item){
            return new ApiServiceNestedImpl(item);
    }

    public KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> editApiService(){
            return withNewApiServiceLike(getApiService());
    }

    public KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> editOrNewApiService(){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): new ResourceTemplateBuilder().build());
    }

    public KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(ResourceTemplate item){
            return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodDisruptionBudget instead.
 * @return The buildable object.
 */
@Deprecated public PodDisruptionBudgetTemplate getPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget){
            _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
            if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public Boolean hasPodDisruptionBudget(){
            return this.podDisruptionBudget != null;
    }

    public KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget(){
            return new PodDisruptionBudgetNestedImpl();
    }

    public KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return new PodDisruptionBudgetNestedImpl(item);
    }

    public KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new PodDisruptionBudgetTemplateBuilder().build());
    }

    public KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMirrorMaker2Container instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getMirrorMaker2Container(){
            return this.mirrorMaker2Container!=null?this.mirrorMaker2Container.build():null;
    }

    public ContainerTemplate buildMirrorMaker2Container(){
            return this.mirrorMaker2Container!=null?this.mirrorMaker2Container.build():null;
    }

    public A withMirrorMaker2Container(ContainerTemplate mirrorMaker2Container){
            _visitables.get("mirrorMaker2Container").remove(this.mirrorMaker2Container);
            if (mirrorMaker2Container!=null){ this.mirrorMaker2Container= new ContainerTemplateBuilder(mirrorMaker2Container); _visitables.get("mirrorMaker2Container").add(this.mirrorMaker2Container);} return (A) this;
    }

    public Boolean hasMirrorMaker2Container(){
            return this.mirrorMaker2Container != null;
    }

    public KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> withNewMirrorMaker2Container(){
            return new MirrorMaker2ContainerNestedImpl();
    }

    public KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> withNewMirrorMaker2ContainerLike(ContainerTemplate item){
            return new MirrorMaker2ContainerNestedImpl(item);
    }

    public KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> editMirrorMaker2Container(){
            return withNewMirrorMaker2ContainerLike(getMirrorMaker2Container());
    }

    public KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> editOrNewMirrorMaker2Container(){
            return withNewMirrorMaker2ContainerLike(getMirrorMaker2Container() != null ? getMirrorMaker2Container(): new ContainerTemplateBuilder().build());
    }

    public KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> editOrNewMirrorMaker2ContainerLike(ContainerTemplate item){
            return withNewMirrorMaker2ContainerLike(getMirrorMaker2Container() != null ? getMirrorMaker2Container(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaMirrorMaker2TemplateFluentImpl that = (KafkaMirrorMaker2TemplateFluentImpl) o;
            if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
            if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
            if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
            if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
            if (mirrorMaker2Container != null ? !mirrorMaker2Container.equals(that.mirrorMaker2Container) :that.mirrorMaker2Container != null) return false;
            return true;
    }


    public class DeploymentNestedImpl<N> extends DeploymentTemplateFluentImpl<KafkaMirrorMaker2TemplateFluent.DeploymentNested<N>> implements KafkaMirrorMaker2TemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentTemplateBuilder builder;
    
            DeploymentNestedImpl(DeploymentTemplate item){
                    this.builder = new DeploymentTemplateBuilder(this, item);
            }
            DeploymentNestedImpl(){
                    this.builder = new DeploymentTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withDeployment(builder.build());
    }
    public N endDeployment(){
            return and();
    }

}
    public class PodNestedImpl<N> extends PodTemplateFluentImpl<KafkaMirrorMaker2TemplateFluent.PodNested<N>> implements KafkaMirrorMaker2TemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withPod(builder.build());
    }
    public N endPod(){
            return and();
    }

}
    public class ApiServiceNestedImpl<N> extends ResourceTemplateFluentImpl<KafkaMirrorMaker2TemplateFluent.ApiServiceNested<N>> implements KafkaMirrorMaker2TemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceTemplateBuilder builder;
    
            ApiServiceNestedImpl(ResourceTemplate item){
                    this.builder = new ResourceTemplateBuilder(this, item);
            }
            ApiServiceNestedImpl(){
                    this.builder = new ResourceTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withApiService(builder.build());
    }
    public N endApiService(){
            return and();
    }

}
    public class PodDisruptionBudgetNestedImpl<N> extends PodDisruptionBudgetTemplateFluentImpl<KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<N>> implements KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodDisruptionBudgetTemplateBuilder builder;
    
            PodDisruptionBudgetNestedImpl(PodDisruptionBudgetTemplate item){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
            }
            PodDisruptionBudgetNestedImpl(){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget(){
            return and();
    }

}
    public class MirrorMaker2ContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<N>> implements KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            MirrorMaker2ContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            MirrorMaker2ContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withMirrorMaker2Container(builder.build());
    }
    public N endMirrorMaker2Container(){
            return and();
    }

}


}
