package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class KafkaMirrorMakerTemplateFluentImpl<A extends KafkaMirrorMakerTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaMirrorMakerTemplateFluent<A>{

    private DeploymentTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder mirrorMakerContainer;

    public KafkaMirrorMakerTemplateFluentImpl(){
    }
    public KafkaMirrorMakerTemplateFluentImpl(KafkaMirrorMakerTemplate instance){
            this.withDeployment(instance.getDeployment());

            this.withPod(instance.getPod());

            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());

            this.withMirrorMakerContainer(instance.getMirrorMakerContainer());

    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentTemplate getDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public DeploymentTemplate buildDeployment(){
            return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(DeploymentTemplate deployment){
            _visitables.get("deployment").remove(this.deployment);
            if (deployment!=null){ this.deployment= new DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment(){
            return this.deployment != null;
    }

    public KafkaMirrorMakerTemplateFluent.DeploymentNested<A> withNewDeployment(){
            return new DeploymentNestedImpl();
    }

    public KafkaMirrorMakerTemplateFluent.DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item){
            return new DeploymentNestedImpl(item);
    }

    public KafkaMirrorMakerTemplateFluent.DeploymentNested<A> editDeployment(){
            return withNewDeploymentLike(getDeployment());
    }

    public KafkaMirrorMakerTemplateFluent.DeploymentNested<A> editOrNewDeployment(){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new DeploymentTemplateBuilder().build());
    }

    public KafkaMirrorMakerTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item){
            return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod(){
            return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod){
            _visitables.get("pod").remove(this.pod);
            if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod(){
            return this.pod != null;
    }

    public KafkaMirrorMakerTemplateFluent.PodNested<A> withNewPod(){
            return new PodNestedImpl();
    }

    public KafkaMirrorMakerTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item){
            return new PodNestedImpl(item);
    }

    public KafkaMirrorMakerTemplateFluent.PodNested<A> editPod(){
            return withNewPodLike(getPod());
    }

    public KafkaMirrorMakerTemplateFluent.PodNested<A> editOrNewPod(){
            return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public KafkaMirrorMakerTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item){
            return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodDisruptionBudget instead.
 * @return The buildable object.
 */
@Deprecated public PodDisruptionBudgetTemplate getPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget(){
            return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget){
            _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
            if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public Boolean hasPodDisruptionBudget(){
            return this.podDisruptionBudget != null;
    }

    public KafkaMirrorMakerTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget(){
            return new PodDisruptionBudgetNestedImpl();
    }

    public KafkaMirrorMakerTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return new PodDisruptionBudgetNestedImpl(item);
    }

    public KafkaMirrorMakerTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public KafkaMirrorMakerTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget(){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new PodDisruptionBudgetTemplateBuilder().build());
    }

    public KafkaMirrorMakerTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item){
            return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMirrorMakerContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getMirrorMakerContainer(){
            return this.mirrorMakerContainer!=null?this.mirrorMakerContainer.build():null;
    }

    public ContainerTemplate buildMirrorMakerContainer(){
            return this.mirrorMakerContainer!=null?this.mirrorMakerContainer.build():null;
    }

    public A withMirrorMakerContainer(ContainerTemplate mirrorMakerContainer){
            _visitables.get("mirrorMakerContainer").remove(this.mirrorMakerContainer);
            if (mirrorMakerContainer!=null){ this.mirrorMakerContainer= new ContainerTemplateBuilder(mirrorMakerContainer); _visitables.get("mirrorMakerContainer").add(this.mirrorMakerContainer);} return (A) this;
    }

    public Boolean hasMirrorMakerContainer(){
            return this.mirrorMakerContainer != null;
    }

    public KafkaMirrorMakerTemplateFluent.MirrorMakerContainerNested<A> withNewMirrorMakerContainer(){
            return new MirrorMakerContainerNestedImpl();
    }

    public KafkaMirrorMakerTemplateFluent.MirrorMakerContainerNested<A> withNewMirrorMakerContainerLike(ContainerTemplate item){
            return new MirrorMakerContainerNestedImpl(item);
    }

    public KafkaMirrorMakerTemplateFluent.MirrorMakerContainerNested<A> editMirrorMakerContainer(){
            return withNewMirrorMakerContainerLike(getMirrorMakerContainer());
    }

    public KafkaMirrorMakerTemplateFluent.MirrorMakerContainerNested<A> editOrNewMirrorMakerContainer(){
            return withNewMirrorMakerContainerLike(getMirrorMakerContainer() != null ? getMirrorMakerContainer(): new ContainerTemplateBuilder().build());
    }

    public KafkaMirrorMakerTemplateFluent.MirrorMakerContainerNested<A> editOrNewMirrorMakerContainerLike(ContainerTemplate item){
            return withNewMirrorMakerContainerLike(getMirrorMakerContainer() != null ? getMirrorMakerContainer(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaMirrorMakerTemplateFluentImpl that = (KafkaMirrorMakerTemplateFluentImpl) o;
            if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
            if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
            if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
            if (mirrorMakerContainer != null ? !mirrorMakerContainer.equals(that.mirrorMakerContainer) :that.mirrorMakerContainer != null) return false;
            return true;
    }


    public class DeploymentNestedImpl<N> extends DeploymentTemplateFluentImpl<KafkaMirrorMakerTemplateFluent.DeploymentNested<N>> implements KafkaMirrorMakerTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentTemplateBuilder builder;
    
            DeploymentNestedImpl(DeploymentTemplate item){
                    this.builder = new DeploymentTemplateBuilder(this, item);
            }
            DeploymentNestedImpl(){
                    this.builder = new DeploymentTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerTemplateFluentImpl.this.withDeployment(builder.build());
    }
    public N endDeployment(){
            return and();
    }

}
    public class PodNestedImpl<N> extends PodTemplateFluentImpl<KafkaMirrorMakerTemplateFluent.PodNested<N>> implements KafkaMirrorMakerTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
    
            PodNestedImpl(PodTemplate item){
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodNestedImpl(){
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerTemplateFluentImpl.this.withPod(builder.build());
    }
    public N endPod(){
            return and();
    }

}
    public class PodDisruptionBudgetNestedImpl<N> extends PodDisruptionBudgetTemplateFluentImpl<KafkaMirrorMakerTemplateFluent.PodDisruptionBudgetNested<N>> implements KafkaMirrorMakerTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodDisruptionBudgetTemplateBuilder builder;
    
            PodDisruptionBudgetNestedImpl(PodDisruptionBudgetTemplate item){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
            }
            PodDisruptionBudgetNestedImpl(){
                    this.builder = new PodDisruptionBudgetTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget(){
            return and();
    }

}
    public class MirrorMakerContainerNestedImpl<N> extends ContainerTemplateFluentImpl<KafkaMirrorMakerTemplateFluent.MirrorMakerContainerNested<N>> implements KafkaMirrorMakerTemplateFluent.MirrorMakerContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerTemplateBuilder builder;
    
            MirrorMakerContainerNestedImpl(ContainerTemplate item){
                    this.builder = new ContainerTemplateBuilder(this, item);
            }
            MirrorMakerContainerNestedImpl(){
                    this.builder = new ContainerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerTemplateFluentImpl.this.withMirrorMakerContainer(builder.build());
    }
    public N endMirrorMakerContainer(){
            return and();
    }

}


}
