package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserTemplateBuilder extends KafkaUserTemplateFluentImpl<KafkaUserTemplateBuilder> implements VisitableBuilder<KafkaUserTemplate,KafkaUserTemplateBuilder>{

    KafkaUserTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserTemplateBuilder(){
            this(true);
    }
    public KafkaUserTemplateBuilder(Boolean validationEnabled){
            this(new KafkaUserTemplate(), validationEnabled);
    }
    public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaUserTemplate(), validationEnabled);
    }
    public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent,KafkaUserTemplate instance){
            this(fluent, instance, true);
    }
    public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent,KafkaUserTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaUserTemplateBuilder(KafkaUserTemplate instance){
            this(instance,true);
    }
    public KafkaUserTemplateBuilder(KafkaUserTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaUserTemplate build(){
            KafkaUserTemplate buildable = new KafkaUserTemplate();
            buildable.setSecret(fluent.getSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaUserTemplateBuilder that = (KafkaUserTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
