package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodTemplateBuilder extends PodTemplateFluentImpl<PodTemplateBuilder> implements VisitableBuilder<PodTemplate,PodTemplateBuilder>{

    PodTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public PodTemplateBuilder(){
            this(true);
    }
    public PodTemplateBuilder(Boolean validationEnabled){
            this(new PodTemplate(), validationEnabled);
    }
    public PodTemplateBuilder(PodTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public PodTemplateBuilder(PodTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PodTemplate(), validationEnabled);
    }
    public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance){
            this(fluent, instance, true);
    }
    public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata());

            fluent.withImagePullSecrets(instance.getImagePullSecrets());

            fluent.withSecurityContext(instance.getSecurityContext());

            fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());

            fluent.withAffinity(instance.getAffinity());

            fluent.withTolerations(instance.getTolerations());

            fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());

            fluent.withPriorityClassName(instance.getPriorityClassName());

            fluent.withSchedulerName(instance.getSchedulerName());

            fluent.withHostAliases(instance.getHostAliases());

            this.validationEnabled = validationEnabled; 
    }
    public PodTemplateBuilder(PodTemplate instance){
            this(instance,true);
    }
    public PodTemplateBuilder(PodTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata());

            this.withImagePullSecrets(instance.getImagePullSecrets());

            this.withSecurityContext(instance.getSecurityContext());

            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());

            this.withPriorityClassName(instance.getPriorityClassName());

            this.withSchedulerName(instance.getSchedulerName());

            this.withHostAliases(instance.getHostAliases());

            this.validationEnabled = validationEnabled; 
    }

    public PodTemplate build(){
            PodTemplate buildable = new PodTemplate();
            buildable.setMetadata(fluent.getMetadata());
            buildable.setImagePullSecrets(fluent.getImagePullSecrets());
            buildable.setSecurityContext(fluent.getSecurityContext());
            buildable.setTerminationGracePeriodSeconds(fluent.getTerminationGracePeriodSeconds());
            buildable.setAffinity(fluent.getAffinity());
            buildable.setTolerations(fluent.getTolerations());
            buildable.setTopologySpreadConstraints(fluent.getTopologySpreadConstraints());
            buildable.setPriorityClassName(fluent.getPriorityClassName());
            buildable.setSchedulerName(fluent.getSchedulerName());
            buildable.setHostAliases(fluent.getHostAliases());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodTemplateBuilder that = (PodTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
