package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceTemplateBuilder extends ResourceTemplateFluentImpl<ResourceTemplateBuilder> implements VisitableBuilder<ResourceTemplate,ResourceTemplateBuilder>{

    ResourceTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceTemplateBuilder(){
            this(true);
    }
    public ResourceTemplateBuilder(Boolean validationEnabled){
            this(new ResourceTemplate(), validationEnabled);
    }
    public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ResourceTemplate(), validationEnabled);
    }
    public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent,ResourceTemplate instance){
            this(fluent, instance, true);
    }
    public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent,ResourceTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public ResourceTemplateBuilder(ResourceTemplate instance){
            this(instance,true);
    }
    public ResourceTemplateBuilder(ResourceTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public ResourceTemplate build(){
            ResourceTemplate buildable = new ResourceTemplate();
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceTemplateBuilder that = (ResourceTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
