package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StatefulSetTemplateBuilder extends StatefulSetTemplateFluentImpl<StatefulSetTemplateBuilder> implements VisitableBuilder<StatefulSetTemplate,StatefulSetTemplateBuilder>{

    StatefulSetTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetTemplateBuilder(){
            this(true);
    }
    public StatefulSetTemplateBuilder(Boolean validationEnabled){
            this(new StatefulSetTemplate(), validationEnabled);
    }
    public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StatefulSetTemplate(), validationEnabled);
    }
    public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent,StatefulSetTemplate instance){
            this(fluent, instance, true);
    }
    public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent,StatefulSetTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata());

            fluent.withPodManagementPolicy(instance.getPodManagementPolicy());

            this.validationEnabled = validationEnabled; 
    }
    public StatefulSetTemplateBuilder(StatefulSetTemplate instance){
            this(instance,true);
    }
    public StatefulSetTemplateBuilder(StatefulSetTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata());

            this.withPodManagementPolicy(instance.getPodManagementPolicy());

            this.validationEnabled = validationEnabled; 
    }

    public StatefulSetTemplate build(){
            StatefulSetTemplate buildable = new StatefulSetTemplate();
            buildable.setMetadata(fluent.getMetadata());
            buildable.setPodManagementPolicy(fluent.getPodManagementPolicy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatefulSetTemplateBuilder that = (StatefulSetTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
