/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceDoneable;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.strimzi.api.kafka.KafkaBridgeList;
import io.strimzi.api.kafka.KafkaConnectList;
import io.strimzi.api.kafka.KafkaConnectS2IList;
import io.strimzi.api.kafka.KafkaConnectorList;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.KafkaMirrorMaker2List;
import io.strimzi.api.kafka.KafkaMirrorMakerList;
import io.strimzi.api.kafka.KafkaRebalanceList;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.KafkaUserList;
import io.strimzi.api.kafka.model.DoneableKafka;
import io.strimzi.api.kafka.model.DoneableKafkaBridge;
import io.strimzi.api.kafka.model.DoneableKafkaConnect;
import io.strimzi.api.kafka.model.DoneableKafkaConnectS2I;
import io.strimzi.api.kafka.model.DoneableKafkaConnector;
import io.strimzi.api.kafka.model.DoneableKafkaMirrorMaker;
import io.strimzi.api.kafka.model.DoneableKafkaMirrorMaker2;
import io.strimzi.api.kafka.model.DoneableKafkaRebalance;
import io.strimzi.api.kafka.model.DoneableKafkaTopic;
import io.strimzi.api.kafka.model.DoneableKafkaUser;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBridge;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectS2I;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.api.kafka.model.KafkaMirrorMaker;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2;
import io.strimzi.api.kafka.model.KafkaRebalance;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.api.kafka.model.KafkaUser;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Crds {
    private static final Class<? extends CustomResource>[] CRDS = new Class[]{Kafka.class, KafkaConnect.class, KafkaConnectS2I.class, KafkaTopic.class, KafkaUser.class, KafkaMirrorMaker.class, KafkaBridge.class, KafkaConnector.class, KafkaMirrorMaker2.class, KafkaRebalance.class};

    private Crds() {
    }

    public static void registerCustomKinds() {
        for (Class<? extends CustomResource> crdClass : CRDS) {
            for (String version : Crds.apiVersions(crdClass)) {
                KubernetesDeserializer.registerCustomKind((String)version, (String)Crds.kind(crdClass), crdClass);
            }
        }
    }

    private static CustomResourceDefinition crd(Class<? extends CustomResource> cls) {
        String version = null;
        if (cls.equals(Kafka.class)) {
            version = "v1beta1";
        } else if (cls.equals(KafkaConnect.class)) {
            version = KafkaConnect.VERSIONS.get(0);
        } else if (cls.equals(KafkaConnectS2I.class)) {
            version = KafkaConnectS2I.VERSIONS.get(0);
        } else if (cls.equals(KafkaTopic.class)) {
            version = KafkaTopic.VERSIONS.get(0);
        } else if (cls.equals(KafkaUser.class)) {
            version = KafkaUser.VERSIONS.get(0);
        } else if (cls.equals(KafkaMirrorMaker.class)) {
            version = KafkaMirrorMaker.VERSIONS.get(0);
        } else if (cls.equals(KafkaBridge.class)) {
            version = KafkaBridge.VERSIONS.get(0);
        } else if (cls.equals(KafkaConnector.class)) {
            version = KafkaConnector.VERSIONS.get(0);
        } else if (cls.equals(KafkaMirrorMaker2.class)) {
            version = KafkaMirrorMaker2.VERSIONS.get(0);
        } else if (cls.equals(KafkaRebalance.class)) {
            version = KafkaRebalance.VERSIONS.get(0);
        } else {
            throw new RuntimeException();
        }
        return Crds.crd(cls, version);
    }

    private static CustomResourceDefinition crd(Class<? extends CustomResource> cls, String version) {
        String listKind;
        String kind;
        String group;
        String singular;
        String plural;
        String crdApiVersion;
        String scope;
        CustomResourceSubresourceStatus status = null;
        if (cls.equals(Kafka.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkas";
            singular = "kafka";
            group = "kafka.strimzi.io";
            kind = "Kafka";
            listKind = "KafkaList";
            status = new CustomResourceSubresourceStatus();
            if (!Kafka.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaConnect.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkaconnects";
            singular = "kafkaconnect";
            group = "kafka.strimzi.io";
            kind = "KafkaConnect";
            listKind = "KafkaConnectList";
            status = new CustomResourceSubresourceStatus();
            if (!KafkaConnect.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaConnectS2I.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkaconnects2is";
            singular = "kafkaconnects2i";
            group = "kafka.strimzi.io";
            kind = "KafkaConnectS2I";
            listKind = "KafkaConnectS2IList";
            status = new CustomResourceSubresourceStatus();
            if (!KafkaConnectS2I.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaTopic.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkatopics";
            singular = "kafkatopic";
            group = "kafka.strimzi.io";
            kind = "KafkaTopic";
            listKind = "KafkaTopicList";
            if (!KafkaTopic.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaUser.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkausers";
            singular = "kafkauser";
            group = "kafka.strimzi.io";
            kind = "KafkaUser";
            listKind = "KafkaUserList";
            status = new CustomResourceSubresourceStatus();
            if (!KafkaUser.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaMirrorMaker.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkamirrormakers";
            singular = "kafkamirrormaker";
            group = "kafka.strimzi.io";
            kind = "KafkaMirrorMaker";
            listKind = "KafkaMirrorMakerList";
            status = new CustomResourceSubresourceStatus();
            if (!KafkaMirrorMaker.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaBridge.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkabridges";
            singular = "kafkabridge";
            group = "kafka.strimzi.io";
            kind = "KafkaBridge";
            listKind = "KafkaBridgeList";
            status = new CustomResourceSubresourceStatus();
            if (!KafkaBridge.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaConnector.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkaconnectors";
            singular = "kafkaconnector";
            group = "kafka.strimzi.io";
            kind = "KafkaConnector";
            listKind = "KafkaConnectorList";
            status = new CustomResourceSubresourceStatus();
            if (!KafkaConnector.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaMirrorMaker2.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkamirrormaker2s";
            singular = "kafkamirrormaker2";
            group = "kafka.strimzi.io";
            kind = "KafkaMirrorMaker2";
            listKind = "KafkaMirrorMaker2List";
            status = new CustomResourceSubresourceStatus();
            if (!KafkaMirrorMaker2.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else if (cls.equals(KafkaRebalance.class)) {
            scope = "Namespaced";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkarebalances";
            singular = "kafkarebalance";
            group = "kafka.strimzi.io";
            kind = "KafkaRebalance";
            listKind = "KafkaRebalanceList";
            status = new CustomResourceSubresourceStatus();
            if (!KafkaRebalance.VERSIONS.contains(version)) {
                throw new RuntimeException();
            }
        } else {
            throw new RuntimeException();
        }
        return ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.SubresourcesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionBuilder)new CustomResourceDefinitionBuilder().withApiVersion(crdApiVersion)).withKind("CustomResourceDefinition")).withNewMetadata().withName(plural + "." + group)).endMetadata()).withNewSpec().withScope(scope)).withGroup(group)).withVersion(version)).withNewNames().withSingular(singular)).withPlural(plural)).withKind(kind)).withListKind(listKind)).endNames()).withNewSubresources().withStatus(status)).endSubresources()).endSpec()).build();
    }

    public static CustomResourceDefinition kafka() {
        return Crds.crd(Kafka.class);
    }

    public static MixedOperation<Kafka, KafkaList, DoneableKafka, Resource<Kafka, DoneableKafka>> kafkaOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafka()), Kafka.class, KafkaList.class, DoneableKafka.class);
    }

    public static MixedOperation<Kafka, KafkaList, DoneableKafka, Resource<Kafka, DoneableKafka>> kafkaV1Alpha1Operation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.crd(Kafka.class, "v1alpha1")), Kafka.class, KafkaList.class, DoneableKafka.class);
    }

    public static MixedOperation<Kafka, KafkaList, DoneableKafka, Resource<Kafka, DoneableKafka>> kafkaV1Beta1Operation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.crd(Kafka.class, "v1beta1")), Kafka.class, KafkaList.class, DoneableKafka.class);
    }

    public static MixedOperation<Kafka, KafkaList, DoneableKafka, Resource<Kafka, DoneableKafka>> kafkaV1Beta2Operation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.crd(Kafka.class, "v1beta2")), Kafka.class, KafkaList.class, DoneableKafka.class);
    }

    public static MixedOperation<Kafka, KafkaList, DoneableKafka, Resource<Kafka, DoneableKafka>> kafkaV1Operation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.crd(Kafka.class, "v1")), Kafka.class, KafkaList.class, DoneableKafka.class);
    }

    public static CustomResourceDefinition kafkaConnect() {
        return Crds.crd(KafkaConnect.class);
    }

    public static MixedOperation<KafkaConnect, KafkaConnectList, DoneableKafkaConnect, Resource<KafkaConnect, DoneableKafkaConnect>> kafkaConnectOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaConnect()), KafkaConnect.class, KafkaConnectList.class, DoneableKafkaConnect.class);
    }

    public static CustomResourceDefinition kafkaConnector() {
        return Crds.crd(KafkaConnector.class);
    }

    public static MixedOperation<KafkaConnector, KafkaConnectorList, DoneableKafkaConnector, Resource<KafkaConnector, DoneableKafkaConnector>> kafkaConnectorOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaConnector()), KafkaConnector.class, KafkaConnectorList.class, DoneableKafkaConnector.class);
    }

    public static CustomResourceDefinition kafkaConnectS2I() {
        return Crds.crd(KafkaConnectS2I.class);
    }

    public static <D extends CustomResourceDoneable<T>, T extends CustomResource> MixedOperation<KafkaConnectS2I, KafkaConnectS2IList, DoneableKafkaConnectS2I, Resource<KafkaConnectS2I, DoneableKafkaConnectS2I>> kafkaConnectS2iOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaConnectS2I()), KafkaConnectS2I.class, KafkaConnectS2IList.class, DoneableKafkaConnectS2I.class);
    }

    public static CustomResourceDefinition kafkaTopic() {
        return Crds.crd(KafkaTopic.class);
    }

    public static MixedOperation<KafkaTopic, KafkaTopicList, DoneableKafkaTopic, Resource<KafkaTopic, DoneableKafkaTopic>> topicOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaTopic()), KafkaTopic.class, KafkaTopicList.class, DoneableKafkaTopic.class);
    }

    public static CustomResourceDefinition kafkaUser() {
        return Crds.crd(KafkaUser.class);
    }

    public static MixedOperation<KafkaUser, KafkaUserList, DoneableKafkaUser, Resource<KafkaUser, DoneableKafkaUser>> kafkaUserOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaUser()), KafkaUser.class, KafkaUserList.class, DoneableKafkaUser.class);
    }

    public static CustomResourceDefinition kafkaMirrorMaker() {
        return Crds.crd(KafkaMirrorMaker.class);
    }

    public static MixedOperation<KafkaMirrorMaker, KafkaMirrorMakerList, DoneableKafkaMirrorMaker, Resource<KafkaMirrorMaker, DoneableKafkaMirrorMaker>> mirrorMakerOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaMirrorMaker()), KafkaMirrorMaker.class, KafkaMirrorMakerList.class, DoneableKafkaMirrorMaker.class);
    }

    public static CustomResourceDefinition kafkaBridge() {
        return Crds.crd(KafkaBridge.class);
    }

    public static MixedOperation<KafkaBridge, KafkaBridgeList, DoneableKafkaBridge, Resource<KafkaBridge, DoneableKafkaBridge>> kafkaBridgeOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaBridge()), KafkaBridge.class, KafkaBridgeList.class, DoneableKafkaBridge.class);
    }

    public static CustomResourceDefinition kafkaMirrorMaker2() {
        return Crds.crd(KafkaMirrorMaker2.class);
    }

    public static MixedOperation<KafkaMirrorMaker2, KafkaMirrorMaker2List, DoneableKafkaMirrorMaker2, Resource<KafkaMirrorMaker2, DoneableKafkaMirrorMaker2>> kafkaMirrorMaker2Operation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaMirrorMaker2()), KafkaMirrorMaker2.class, KafkaMirrorMaker2List.class, DoneableKafkaMirrorMaker2.class);
    }

    public static CustomResourceDefinition kafkaRebalance() {
        return Crds.crd(KafkaRebalance.class);
    }

    public static MixedOperation<KafkaRebalance, KafkaRebalanceList, DoneableKafkaRebalance, Resource<KafkaRebalance, DoneableKafkaRebalance>> kafkaRebalanceOperation(KubernetesClient client) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.kafkaRebalance()), KafkaRebalance.class, KafkaRebalanceList.class, DoneableKafkaRebalance.class);
    }

    public static <T extends CustomResource, L extends CustomResourceList<T>, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> operation(KubernetesClient client, Class<T> cls, Class<L> listCls, Class<D> doneableCls) {
        return client.customResources(CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)Crds.crd(cls)), cls, listCls, doneableCls);
    }

    public static <T extends CustomResource> String kind(Class<T> cls) {
        try {
            return ((CustomResource)cls.newInstance()).getKind();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends CustomResource> List<String> apiVersions(Class<T> cls) {
        try {
            List<CallSite> versions;
            String group = (String)cls.getField("RESOURCE_GROUP").get(null);
            try {
                versions = Collections.singletonList(group + "/" + (String)cls.getField("VERSION").get(null));
            }
            catch (NoSuchFieldException e) {
                versions = ((List)cls.getField("VERSIONS").get(null)).stream().map(v -> group + "/" + v).collect(Collectors.toList());
            }
            return versions;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getNumCrds() {
        return CRDS.length;
    }
}

