/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.AclResourcePatternType;
import io.strimzi.api.kafka.model.AclRuleResource;
import io.strimzi.crdgenerator.annotations.Description;
import io.vertx.core.cli.annotations.DefaultValue;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "name", "patternType"})
public class AclRuleGroupResource
extends AclRuleResource {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_GROUP = "group";
    private String name;
    private AclResourcePatternType patternType = AclResourcePatternType.LITERAL;

    @Override
    @Description(value="Must be `group`")
    public String getType() {
        return TYPE_GROUP;
    }

    @Description(value="Describes the pattern used in the resource field. The supported types are `literal` and `prefix`. With `literal` pattern type, the resource field will be used as a definition of a full topic name. With `prefix` pattern type, the resource name will be used only as a prefix. Default value is `literal`.")
    @DefaultValue(value="literal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AclResourcePatternType getPatternType() {
        return this.patternType;
    }

    public void setPatternType(AclResourcePatternType patternType) {
        this.patternType = patternType;
    }

    @Description(value="Name of resource for which given ACL rule applies. Can be combined with `patternType` field to use prefix pattern.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AclRuleGroupResource)) {
            return false;
        }
        AclRuleGroupResource other = (AclRuleGroupResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AclResourcePatternType this$patternType = this.getPatternType();
        AclResourcePatternType other$patternType = other.getPatternType();
        return !(this$patternType == null ? other$patternType != null : !((Object)((Object)this$patternType)).equals((Object)other$patternType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AclRuleGroupResource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AclResourcePatternType $patternType = this.getPatternType();
        result = result * 59 + ($patternType == null ? 43 : ((Object)((Object)$patternType)).hashCode());
        return result;
    }
}

