/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.JmxTransSpec;
import io.strimzi.api.kafka.model.JmxTransSpecFluent;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluentImpl;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplate;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateFluentImpl;
import io.strimzi.api.kafka.model.template.JmxTransTemplate;
import io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransTemplateFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JmxTransSpecFluentImpl<A extends JmxTransSpecFluent<A>>
extends BaseFluent<A>
implements JmxTransSpecFluent<A> {
    private String image;
    private String logLevel;
    private List<JmxTransOutputDefinitionTemplateBuilder> outputDefinitions;
    private List<JmxTransQueryTemplateBuilder> kafkaQueries;
    private ResourceRequirements resources;
    private JmxTransTemplateBuilder template;

    public JmxTransSpecFluentImpl() {
    }

    public JmxTransSpecFluentImpl(JmxTransSpec instance) {
        this.withImage(instance.getImage());
        this.withLogLevel(instance.getLogLevel());
        this.withOutputDefinitions(instance.getOutputDefinitions());
        this.withKafkaQueries(instance.getKafkaQueries());
        this.withResources(instance.getResources());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public A withNewLogLevel(String arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A withNewLogLevel(StringBuilder arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A withNewLogLevel(StringBuffer arg1) {
        return this.withLogLevel(new String(arg1));
    }

    @Override
    public A addToOutputDefinitions(int index, JmxTransOutputDefinitionTemplate item) {
        if (this.outputDefinitions == null) {
            this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();
        }
        JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
        this._visitables.get((Object)"outputDefinitions").add(index >= 0 ? index : this._visitables.get((Object)"outputDefinitions").size(), builder);
        this.outputDefinitions.add(index >= 0 ? index : this.outputDefinitions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOutputDefinitions(int index, JmxTransOutputDefinitionTemplate item) {
        if (this.outputDefinitions == null) {
            this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();
        }
        JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"outputDefinitions").size()) {
            this._visitables.get((Object)"outputDefinitions").add(builder);
        } else {
            this._visitables.get((Object)"outputDefinitions").set(index, builder);
        }
        if (index < 0 || index >= this.outputDefinitions.size()) {
            this.outputDefinitions.add(builder);
        } else {
            this.outputDefinitions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOutputDefinitions(JmxTransOutputDefinitionTemplate ... items) {
        if (this.outputDefinitions == null) {
            this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();
        }
        for (JmxTransOutputDefinitionTemplate item : items) {
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            this._visitables.get((Object)"outputDefinitions").add(builder);
            this.outputDefinitions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items) {
        if (this.outputDefinitions == null) {
            this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();
        }
        for (JmxTransOutputDefinitionTemplate item : items) {
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            this._visitables.get((Object)"outputDefinitions").add(builder);
            this.outputDefinitions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOutputDefinitions(JmxTransOutputDefinitionTemplate ... items) {
        for (JmxTransOutputDefinitionTemplate item : items) {
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            this._visitables.get((Object)"outputDefinitions").remove(builder);
            if (this.outputDefinitions == null) continue;
            this.outputDefinitions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items) {
        for (JmxTransOutputDefinitionTemplate item : items) {
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            this._visitables.get((Object)"outputDefinitions").remove(builder);
            if (this.outputDefinitions == null) continue;
            this.outputDefinitions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOutputDefinitions(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
        if (this.outputDefinitions == null) {
            return (A)this;
        }
        Iterator<JmxTransOutputDefinitionTemplateBuilder> each = this.outputDefinitions.iterator();
        List visitables = this._visitables.get((Object)"outputDefinitions");
        while (each.hasNext()) {
            JmxTransOutputDefinitionTemplateBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<JmxTransOutputDefinitionTemplate> getOutputDefinitions() {
        return JmxTransSpecFluentImpl.build(this.outputDefinitions);
    }

    @Override
    public List<JmxTransOutputDefinitionTemplate> buildOutputDefinitions() {
        return JmxTransSpecFluentImpl.build(this.outputDefinitions);
    }

    @Override
    public JmxTransOutputDefinitionTemplate buildOutputDefinition(int index) {
        return this.outputDefinitions.get(index).build();
    }

    @Override
    public JmxTransOutputDefinitionTemplate buildFirstOutputDefinition() {
        return this.outputDefinitions.get(0).build();
    }

    @Override
    public JmxTransOutputDefinitionTemplate buildLastOutputDefinition() {
        return this.outputDefinitions.get(this.outputDefinitions.size() - 1).build();
    }

    @Override
    public JmxTransOutputDefinitionTemplate buildMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
        for (JmxTransOutputDefinitionTemplateBuilder item : this.outputDefinitions) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
        for (JmxTransOutputDefinitionTemplateBuilder item : this.outputDefinitions) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOutputDefinitions(List<JmxTransOutputDefinitionTemplate> outputDefinitions) {
        if (this.outputDefinitions != null) {
            this._visitables.get((Object)"outputDefinitions").removeAll(this.outputDefinitions);
        }
        if (outputDefinitions != null) {
            this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();
            for (JmxTransOutputDefinitionTemplate item : outputDefinitions) {
                this.addToOutputDefinitions(item);
            }
        } else {
            this.outputDefinitions = null;
        }
        return (A)this;
    }

    @Override
    public A withOutputDefinitions(JmxTransOutputDefinitionTemplate ... outputDefinitions) {
        if (this.outputDefinitions != null) {
            this.outputDefinitions.clear();
        }
        if (outputDefinitions != null) {
            for (JmxTransOutputDefinitionTemplate item : outputDefinitions) {
                this.addToOutputDefinitions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutputDefinitions() {
        return this.outputDefinitions != null && !this.outputDefinitions.isEmpty();
    }

    @Override
    public JmxTransSpecFluent.OutputDefinitionsNested<A> addNewOutputDefinition() {
        return new OutputDefinitionsNestedImpl();
    }

    @Override
    public JmxTransSpecFluent.OutputDefinitionsNested<A> addNewOutputDefinitionLike(JmxTransOutputDefinitionTemplate item) {
        return new OutputDefinitionsNestedImpl(-1, item);
    }

    @Override
    public JmxTransSpecFluent.OutputDefinitionsNested<A> setNewOutputDefinitionLike(int index, JmxTransOutputDefinitionTemplate item) {
        return new OutputDefinitionsNestedImpl(index, item);
    }

    @Override
    public JmxTransSpecFluent.OutputDefinitionsNested<A> editOutputDefinition(int index) {
        if (this.outputDefinitions.size() <= index) {
            throw new RuntimeException("Can't edit outputDefinitions. Index exceeds size.");
        }
        return this.setNewOutputDefinitionLike(index, this.buildOutputDefinition(index));
    }

    @Override
    public JmxTransSpecFluent.OutputDefinitionsNested<A> editFirstOutputDefinition() {
        if (this.outputDefinitions.size() == 0) {
            throw new RuntimeException("Can't edit first outputDefinitions. The list is empty.");
        }
        return this.setNewOutputDefinitionLike(0, this.buildOutputDefinition(0));
    }

    @Override
    public JmxTransSpecFluent.OutputDefinitionsNested<A> editLastOutputDefinition() {
        int index = this.outputDefinitions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last outputDefinitions. The list is empty.");
        }
        return this.setNewOutputDefinitionLike(index, this.buildOutputDefinition(index));
    }

    @Override
    public JmxTransSpecFluent.OutputDefinitionsNested<A> editMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.outputDefinitions.size(); ++i) {
            if (!predicate.apply((Object)this.outputDefinitions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching outputDefinitions. No match found.");
        }
        return this.setNewOutputDefinitionLike(index, this.buildOutputDefinition(index));
    }

    @Override
    public A addToKafkaQueries(int index, JmxTransQueryTemplate item) {
        if (this.kafkaQueries == null) {
            this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();
        }
        JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
        this._visitables.get((Object)"kafkaQueries").add(index >= 0 ? index : this._visitables.get((Object)"kafkaQueries").size(), builder);
        this.kafkaQueries.add(index >= 0 ? index : this.kafkaQueries.size(), builder);
        return (A)this;
    }

    @Override
    public A setToKafkaQueries(int index, JmxTransQueryTemplate item) {
        if (this.kafkaQueries == null) {
            this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();
        }
        JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"kafkaQueries").size()) {
            this._visitables.get((Object)"kafkaQueries").add(builder);
        } else {
            this._visitables.get((Object)"kafkaQueries").set(index, builder);
        }
        if (index < 0 || index >= this.kafkaQueries.size()) {
            this.kafkaQueries.add(builder);
        } else {
            this.kafkaQueries.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToKafkaQueries(JmxTransQueryTemplate ... items) {
        if (this.kafkaQueries == null) {
            this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();
        }
        for (JmxTransQueryTemplate item : items) {
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            this._visitables.get((Object)"kafkaQueries").add(builder);
            this.kafkaQueries.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToKafkaQueries(Collection<JmxTransQueryTemplate> items) {
        if (this.kafkaQueries == null) {
            this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();
        }
        for (JmxTransQueryTemplate item : items) {
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            this._visitables.get((Object)"kafkaQueries").add(builder);
            this.kafkaQueries.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromKafkaQueries(JmxTransQueryTemplate ... items) {
        for (JmxTransQueryTemplate item : items) {
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            this._visitables.get((Object)"kafkaQueries").remove(builder);
            if (this.kafkaQueries == null) continue;
            this.kafkaQueries.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromKafkaQueries(Collection<JmxTransQueryTemplate> items) {
        for (JmxTransQueryTemplate item : items) {
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            this._visitables.get((Object)"kafkaQueries").remove(builder);
            if (this.kafkaQueries == null) continue;
            this.kafkaQueries.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromKafkaQueries(Predicate<JmxTransQueryTemplateBuilder> predicate) {
        if (this.kafkaQueries == null) {
            return (A)this;
        }
        Iterator<JmxTransQueryTemplateBuilder> each = this.kafkaQueries.iterator();
        List visitables = this._visitables.get((Object)"kafkaQueries");
        while (each.hasNext()) {
            JmxTransQueryTemplateBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<JmxTransQueryTemplate> getKafkaQueries() {
        return JmxTransSpecFluentImpl.build(this.kafkaQueries);
    }

    @Override
    public List<JmxTransQueryTemplate> buildKafkaQueries() {
        return JmxTransSpecFluentImpl.build(this.kafkaQueries);
    }

    @Override
    public JmxTransQueryTemplate buildKafkaQuery(int index) {
        return this.kafkaQueries.get(index).build();
    }

    @Override
    public JmxTransQueryTemplate buildFirstKafkaQuery() {
        return this.kafkaQueries.get(0).build();
    }

    @Override
    public JmxTransQueryTemplate buildLastKafkaQuery() {
        return this.kafkaQueries.get(this.kafkaQueries.size() - 1).build();
    }

    @Override
    public JmxTransQueryTemplate buildMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
        for (JmxTransQueryTemplateBuilder item : this.kafkaQueries) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
        for (JmxTransQueryTemplateBuilder item : this.kafkaQueries) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withKafkaQueries(List<JmxTransQueryTemplate> kafkaQueries) {
        if (this.kafkaQueries != null) {
            this._visitables.get((Object)"kafkaQueries").removeAll(this.kafkaQueries);
        }
        if (kafkaQueries != null) {
            this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();
            for (JmxTransQueryTemplate item : kafkaQueries) {
                this.addToKafkaQueries(item);
            }
        } else {
            this.kafkaQueries = null;
        }
        return (A)this;
    }

    @Override
    public A withKafkaQueries(JmxTransQueryTemplate ... kafkaQueries) {
        if (this.kafkaQueries != null) {
            this.kafkaQueries.clear();
        }
        if (kafkaQueries != null) {
            for (JmxTransQueryTemplate item : kafkaQueries) {
                this.addToKafkaQueries(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasKafkaQueries() {
        return this.kafkaQueries != null && !this.kafkaQueries.isEmpty();
    }

    @Override
    public JmxTransSpecFluent.KafkaQueriesNested<A> addNewKafkaQuery() {
        return new KafkaQueriesNestedImpl();
    }

    @Override
    public JmxTransSpecFluent.KafkaQueriesNested<A> addNewKafkaQueryLike(JmxTransQueryTemplate item) {
        return new KafkaQueriesNestedImpl(-1, item);
    }

    @Override
    public JmxTransSpecFluent.KafkaQueriesNested<A> setNewKafkaQueryLike(int index, JmxTransQueryTemplate item) {
        return new KafkaQueriesNestedImpl(index, item);
    }

    @Override
    public JmxTransSpecFluent.KafkaQueriesNested<A> editKafkaQuery(int index) {
        if (this.kafkaQueries.size() <= index) {
            throw new RuntimeException("Can't edit kafkaQueries. Index exceeds size.");
        }
        return this.setNewKafkaQueryLike(index, this.buildKafkaQuery(index));
    }

    @Override
    public JmxTransSpecFluent.KafkaQueriesNested<A> editFirstKafkaQuery() {
        if (this.kafkaQueries.size() == 0) {
            throw new RuntimeException("Can't edit first kafkaQueries. The list is empty.");
        }
        return this.setNewKafkaQueryLike(0, this.buildKafkaQuery(0));
    }

    @Override
    public JmxTransSpecFluent.KafkaQueriesNested<A> editLastKafkaQuery() {
        int index = this.kafkaQueries.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last kafkaQueries. The list is empty.");
        }
        return this.setNewKafkaQueryLike(index, this.buildKafkaQuery(index));
    }

    @Override
    public JmxTransSpecFluent.KafkaQueriesNested<A> editMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.kafkaQueries.size(); ++i) {
            if (!predicate.apply((Object)this.kafkaQueries.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching kafkaQueries. No match found.");
        }
        return this.setNewKafkaQueryLike(index, this.buildKafkaQuery(index));
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    @Deprecated
    public JmxTransTemplate getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public JmxTransTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(JmxTransTemplate template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new JmxTransTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public JmxTransSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public JmxTransSpecFluent.TemplateNested<A> withNewTemplateLike(JmxTransTemplate item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public JmxTransSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public JmxTransSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new JmxTransTemplateBuilder().build());
    }

    @Override
    public JmxTransSpecFluent.TemplateNested<A> editOrNewTemplateLike(JmxTransTemplate item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmxTransSpecFluentImpl that = (JmxTransSpecFluentImpl)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.outputDefinitions != null ? !this.outputDefinitions.equals(that.outputDefinitions) : that.outputDefinitions != null) {
            return false;
        }
        if (this.kafkaQueries != null ? !this.kafkaQueries.equals(that.kafkaQueries) : that.kafkaQueries != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals((Object)that.resources) : that.resources != null) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public class TemplateNestedImpl<N>
    extends JmxTransTemplateFluentImpl<JmxTransSpecFluent.TemplateNested<N>>
    implements JmxTransSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final JmxTransTemplateBuilder builder;

        TemplateNestedImpl(JmxTransTemplate item) {
            this.builder = new JmxTransTemplateBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new JmxTransTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)JmxTransSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class KafkaQueriesNestedImpl<N>
    extends JmxTransQueryTemplateFluentImpl<JmxTransSpecFluent.KafkaQueriesNested<N>>
    implements JmxTransSpecFluent.KafkaQueriesNested<N>,
    Nested<N> {
        private final JmxTransQueryTemplateBuilder builder;
        private final int index;

        KafkaQueriesNestedImpl(int index, JmxTransQueryTemplate item) {
            this.index = index;
            this.builder = new JmxTransQueryTemplateBuilder(this, item);
        }

        KafkaQueriesNestedImpl() {
            this.index = -1;
            this.builder = new JmxTransQueryTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)JmxTransSpecFluentImpl.this.setToKafkaQueries(this.index, this.builder.build());
        }

        @Override
        public N endKafkaQuery() {
            return this.and();
        }
    }

    public class OutputDefinitionsNestedImpl<N>
    extends JmxTransOutputDefinitionTemplateFluentImpl<JmxTransSpecFluent.OutputDefinitionsNested<N>>
    implements JmxTransSpecFluent.OutputDefinitionsNested<N>,
    Nested<N> {
        private final JmxTransOutputDefinitionTemplateBuilder builder;
        private final int index;

        OutputDefinitionsNestedImpl(int index, JmxTransOutputDefinitionTemplate item) {
            this.index = index;
            this.builder = new JmxTransOutputDefinitionTemplateBuilder(this, item);
        }

        OutputDefinitionsNestedImpl() {
            this.index = -1;
            this.builder = new JmxTransOutputDefinitionTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)JmxTransSpecFluentImpl.this.setToOutputDefinitions(this.index, this.builder.build());
        }

        @Override
        public N endOutputDefinition() {
            return this.and();
        }
    }
}

