/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsFluent;
import io.strimzi.api.kafka.model.SystemProperty;
import io.strimzi.api.kafka.model.SystemPropertyBuilder;
import io.strimzi.api.kafka.model.SystemPropertyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JvmOptionsFluentImpl<A extends JvmOptionsFluent<A>>
extends BaseFluent<A>
implements JvmOptionsFluent<A> {
    private String xmx;
    private String xms;
    private boolean gcLoggingEnabled;
    private List<SystemPropertyBuilder> javaSystemProperties;
    private Map<String, String> xx;

    public JvmOptionsFluentImpl() {
    }

    public JvmOptionsFluentImpl(JvmOptions instance) {
        this.withXmx(instance.getXmx());
        this.withXms(instance.getXms());
        this.withGcLoggingEnabled(instance.isGcLoggingEnabled());
        this.withJavaSystemProperties(instance.getJavaSystemProperties());
        this.withXx(instance.getXx());
    }

    @Override
    public String getXmx() {
        return this.xmx;
    }

    @Override
    public A withXmx(String xmx) {
        this.xmx = xmx;
        return (A)this;
    }

    @Override
    public Boolean hasXmx() {
        return this.xmx != null;
    }

    @Override
    public A withNewXmx(String arg1) {
        return this.withXmx(new String(arg1));
    }

    @Override
    public A withNewXmx(StringBuilder arg1) {
        return this.withXmx(new String(arg1));
    }

    @Override
    public A withNewXmx(StringBuffer arg1) {
        return this.withXmx(new String(arg1));
    }

    @Override
    public String getXms() {
        return this.xms;
    }

    @Override
    public A withXms(String xms) {
        this.xms = xms;
        return (A)this;
    }

    @Override
    public Boolean hasXms() {
        return this.xms != null;
    }

    @Override
    public A withNewXms(String arg1) {
        return this.withXms(new String(arg1));
    }

    @Override
    public A withNewXms(StringBuilder arg1) {
        return this.withXms(new String(arg1));
    }

    @Override
    public A withNewXms(StringBuffer arg1) {
        return this.withXms(new String(arg1));
    }

    @Override
    public boolean isGcLoggingEnabled() {
        return this.gcLoggingEnabled;
    }

    @Override
    public A withGcLoggingEnabled(boolean gcLoggingEnabled) {
        this.gcLoggingEnabled = gcLoggingEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasGcLoggingEnabled() {
        return true;
    }

    @Override
    public A addToJavaSystemProperties(int index, SystemProperty item) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();
        }
        SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
        this._visitables.get((Object)"javaSystemProperties").add(index >= 0 ? index : this._visitables.get((Object)"javaSystemProperties").size(), builder);
        this.javaSystemProperties.add(index >= 0 ? index : this.javaSystemProperties.size(), builder);
        return (A)this;
    }

    @Override
    public A setToJavaSystemProperties(int index, SystemProperty item) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();
        }
        SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"javaSystemProperties").size()) {
            this._visitables.get((Object)"javaSystemProperties").add(builder);
        } else {
            this._visitables.get((Object)"javaSystemProperties").set(index, builder);
        }
        if (index < 0 || index >= this.javaSystemProperties.size()) {
            this.javaSystemProperties.add(builder);
        } else {
            this.javaSystemProperties.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToJavaSystemProperties(SystemProperty ... items) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();
        }
        for (SystemProperty item : items) {
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            this._visitables.get((Object)"javaSystemProperties").add(builder);
            this.javaSystemProperties.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToJavaSystemProperties(Collection<SystemProperty> items) {
        if (this.javaSystemProperties == null) {
            this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();
        }
        for (SystemProperty item : items) {
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            this._visitables.get((Object)"javaSystemProperties").add(builder);
            this.javaSystemProperties.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromJavaSystemProperties(SystemProperty ... items) {
        for (SystemProperty item : items) {
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            this._visitables.get((Object)"javaSystemProperties").remove(builder);
            if (this.javaSystemProperties == null) continue;
            this.javaSystemProperties.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJavaSystemProperties(Collection<SystemProperty> items) {
        for (SystemProperty item : items) {
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            this._visitables.get((Object)"javaSystemProperties").remove(builder);
            if (this.javaSystemProperties == null) continue;
            this.javaSystemProperties.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromJavaSystemProperties(Predicate<SystemPropertyBuilder> predicate) {
        if (this.javaSystemProperties == null) {
            return (A)this;
        }
        Iterator<SystemPropertyBuilder> each = this.javaSystemProperties.iterator();
        List visitables = this._visitables.get((Object)"javaSystemProperties");
        while (each.hasNext()) {
            SystemPropertyBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SystemProperty> getJavaSystemProperties() {
        return JvmOptionsFluentImpl.build(this.javaSystemProperties);
    }

    @Override
    public List<SystemProperty> buildJavaSystemProperties() {
        return JvmOptionsFluentImpl.build(this.javaSystemProperties);
    }

    @Override
    public SystemProperty buildJavaSystemProperty(int index) {
        return this.javaSystemProperties.get(index).build();
    }

    @Override
    public SystemProperty buildFirstJavaSystemProperty() {
        return this.javaSystemProperties.get(0).build();
    }

    @Override
    public SystemProperty buildLastJavaSystemProperty() {
        return this.javaSystemProperties.get(this.javaSystemProperties.size() - 1).build();
    }

    @Override
    public SystemProperty buildMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
        for (SystemPropertyBuilder item : this.javaSystemProperties) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
        for (SystemPropertyBuilder item : this.javaSystemProperties) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withJavaSystemProperties(List<SystemProperty> javaSystemProperties) {
        if (this.javaSystemProperties != null) {
            this._visitables.get((Object)"javaSystemProperties").removeAll(this.javaSystemProperties);
        }
        if (javaSystemProperties != null) {
            this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();
            for (SystemProperty item : javaSystemProperties) {
                this.addToJavaSystemProperties(item);
            }
        } else {
            this.javaSystemProperties = null;
        }
        return (A)this;
    }

    @Override
    public A withJavaSystemProperties(SystemProperty ... javaSystemProperties) {
        if (this.javaSystemProperties != null) {
            this.javaSystemProperties.clear();
        }
        if (javaSystemProperties != null) {
            for (SystemProperty item : javaSystemProperties) {
                this.addToJavaSystemProperties(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasJavaSystemProperties() {
        return this.javaSystemProperties != null && !this.javaSystemProperties.isEmpty();
    }

    @Override
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> addNewJavaSystemProperty() {
        return new JavaSystemPropertiesNestedImpl();
    }

    @Override
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> addNewJavaSystemPropertyLike(SystemProperty item) {
        return new JavaSystemPropertiesNestedImpl(-1, item);
    }

    @Override
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> setNewJavaSystemPropertyLike(int index, SystemProperty item) {
        return new JavaSystemPropertiesNestedImpl(index, item);
    }

    @Override
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editJavaSystemProperty(int index) {
        if (this.javaSystemProperties.size() <= index) {
            throw new RuntimeException("Can't edit javaSystemProperties. Index exceeds size.");
        }
        return this.setNewJavaSystemPropertyLike(index, this.buildJavaSystemProperty(index));
    }

    @Override
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editFirstJavaSystemProperty() {
        if (this.javaSystemProperties.size() == 0) {
            throw new RuntimeException("Can't edit first javaSystemProperties. The list is empty.");
        }
        return this.setNewJavaSystemPropertyLike(0, this.buildJavaSystemProperty(0));
    }

    @Override
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editLastJavaSystemProperty() {
        int index = this.javaSystemProperties.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last javaSystemProperties. The list is empty.");
        }
        return this.setNewJavaSystemPropertyLike(index, this.buildJavaSystemProperty(index));
    }

    @Override
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.javaSystemProperties.size(); ++i) {
            if (!predicate.apply((Object)this.javaSystemProperties.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching javaSystemProperties. No match found.");
        }
        return this.setNewJavaSystemPropertyLike(index, this.buildJavaSystemProperty(index));
    }

    @Override
    public A addToXx(String key, String value) {
        if (this.xx == null && key != null && value != null) {
            this.xx = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.xx.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToXx(Map<String, String> map) {
        if (this.xx == null && map != null) {
            this.xx = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.xx.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromXx(String key) {
        if (this.xx == null) {
            return (A)this;
        }
        if (key != null && this.xx != null) {
            this.xx.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromXx(Map<String, String> map) {
        if (this.xx == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.xx == null) continue;
                this.xx.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getXx() {
        return this.xx;
    }

    @Override
    public A withXx(Map<String, String> xx) {
        this.xx = xx == null ? null : new LinkedHashMap<String, String>(xx);
        return (A)this;
    }

    @Override
    public Boolean hasXx() {
        return this.xx != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmOptionsFluentImpl that = (JvmOptionsFluentImpl)o;
        if (this.xmx != null ? !this.xmx.equals(that.xmx) : that.xmx != null) {
            return false;
        }
        if (this.xms != null ? !this.xms.equals(that.xms) : that.xms != null) {
            return false;
        }
        if (this.gcLoggingEnabled != that.gcLoggingEnabled) {
            return false;
        }
        if (this.javaSystemProperties != null ? !this.javaSystemProperties.equals(that.javaSystemProperties) : that.javaSystemProperties != null) {
            return false;
        }
        return !(this.xx != null ? !this.xx.equals(that.xx) : that.xx != null);
    }

    public class JavaSystemPropertiesNestedImpl<N>
    extends SystemPropertyFluentImpl<JvmOptionsFluent.JavaSystemPropertiesNested<N>>
    implements JvmOptionsFluent.JavaSystemPropertiesNested<N>,
    Nested<N> {
        private final SystemPropertyBuilder builder;
        private final int index;

        JavaSystemPropertiesNestedImpl(int index, SystemProperty item) {
            this.index = index;
            this.builder = new SystemPropertyBuilder(this, item);
        }

        JavaSystemPropertiesNestedImpl() {
            this.index = -1;
            this.builder = new SystemPropertyBuilder(this);
        }

        @Override
        public N and() {
            return (N)JvmOptionsFluentImpl.this.setToJavaSystemProperties(this.index, this.builder.build());
        }

        @Override
        public N endJavaSystemProperty() {
            return this.and();
        }
    }
}

