/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaBridgeSpec;
import io.strimzi.api.kafka.model.KafkaBridgeSpecFluent;
import io.strimzi.api.kafka.model.KafkaBridgeSpecFluentImpl;

public class KafkaBridgeSpecBuilder
extends KafkaBridgeSpecFluentImpl<KafkaBridgeSpecBuilder>
implements VisitableBuilder<KafkaBridgeSpec, KafkaBridgeSpecBuilder> {
    KafkaBridgeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeSpecBuilder() {
        this(true);
    }

    public KafkaBridgeSpecBuilder(Boolean validationEnabled) {
        this(new KafkaBridgeSpec(), validationEnabled);
    }

    public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaBridgeSpec(), validationEnabled);
    }

    public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent, KafkaBridgeSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent, KafkaBridgeSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withImage(instance.getImage());
        fluent.withHttp(instance.getHttp());
        fluent.withBootstrapServers(instance.getBootstrapServers());
        fluent.withTls(instance.getTls());
        fluent.withAuthentication(instance.getAuthentication());
        fluent.withConsumer(instance.getConsumer());
        fluent.withProducer(instance.getProducer());
        fluent.withResources(instance.getResources());
        fluent.withJvmOptions(instance.getJvmOptions());
        fluent.withLogging(instance.getLogging());
        fluent.withEnableMetrics(instance.getEnableMetrics());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withReadinessProbe(instance.getReadinessProbe());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTracing(instance.getTracing());
        this.validationEnabled = validationEnabled;
    }

    public KafkaBridgeSpecBuilder(KafkaBridgeSpec instance) {
        this(instance, (Boolean)true);
    }

    public KafkaBridgeSpecBuilder(KafkaBridgeSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withImage(instance.getImage());
        this.withHttp(instance.getHttp());
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withTls(instance.getTls());
        this.withAuthentication(instance.getAuthentication());
        this.withConsumer(instance.getConsumer());
        this.withProducer(instance.getProducer());
        this.withResources(instance.getResources());
        this.withJvmOptions(instance.getJvmOptions());
        this.withLogging(instance.getLogging());
        this.withEnableMetrics(instance.getEnableMetrics());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withTemplate(instance.getTemplate());
        this.withTracing(instance.getTracing());
        this.validationEnabled = validationEnabled;
    }

    public KafkaBridgeSpec build() {
        KafkaBridgeSpec buildable = new KafkaBridgeSpec();
        buildable.setReplicas(this.fluent.getReplicas());
        buildable.setImage(this.fluent.getImage());
        buildable.setHttp(this.fluent.getHttp());
        buildable.setBootstrapServers(this.fluent.getBootstrapServers());
        buildable.setTls(this.fluent.getTls());
        buildable.setAuthentication(this.fluent.getAuthentication());
        buildable.setConsumer(this.fluent.getConsumer());
        buildable.setProducer(this.fluent.getProducer());
        buildable.setResources(this.fluent.getResources());
        buildable.setJvmOptions(this.fluent.getJvmOptions());
        buildable.setLogging(this.fluent.getLogging());
        buildable.setEnableMetrics(this.fluent.isEnableMetrics());
        buildable.setLivenessProbe(this.fluent.getLivenessProbe());
        buildable.setReadinessProbe(this.fluent.getReadinessProbe());
        buildable.setTemplate(this.fluent.getTemplate());
        buildable.setTracing(this.fluent.getTracing());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBridgeSpecBuilder that = (KafkaBridgeSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

