/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

public class KafkaConnectResources {
    protected KafkaConnectResources() {
    }

    public static String deploymentName(String clusterName) {
        return clusterName + "-connect";
    }

    public static String serviceAccountName(String clusterName) {
        return KafkaConnectResources.deploymentName(clusterName);
    }

    public static String serviceName(String clusterName) {
        return clusterName + "-connect-api";
    }

    public static String metricsAndLogConfigMapName(String clusterName) {
        return KafkaConnectResources.deploymentName(clusterName) + "-config";
    }

    public static String configStorageTopicOffsets(String clusterName) {
        return KafkaConnectResources.deploymentName(clusterName) + "-offsets";
    }

    public static String configStorageTopicStatus(String clusterName) {
        return KafkaConnectResources.deploymentName(clusterName) + "-status";
    }

    public static String qualifiedServiceName(String clusterName, String namespace) {
        return KafkaConnectResources.serviceName(clusterName) + "." + namespace + ".svc";
    }

    public static String url(String clusterName, String namespace, int port) {
        return "http://" + KafkaConnectResources.qualifiedServiceName(clusterName, namespace) + ":" + port;
    }

    public static String initContainerClusterRoleBindingName(String clusterName, String namespace) {
        return "strimzi-" + namespace + "-" + KafkaConnectResources.deploymentName(clusterName) + "-init";
    }

    public static String dockerFileConfigMapName(String clusterName) {
        return KafkaConnectResources.deploymentName(clusterName) + "-dockerfile";
    }

    public static String buildPodName(String clusterName) {
        return KafkaConnectResources.deploymentName(clusterName) + "-build";
    }

    public static String buildConfigName(String clusterName) {
        return KafkaConnectResources.deploymentName(clusterName) + "-build";
    }
}

