/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.AbstractKafkaConnectSpec;
import io.strimzi.api.kafka.model.KafkaConnectTls;
import io.strimzi.api.kafka.model.Rack;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "version", "image", "bootstrapServers", "tls", "authentication", "config", "resources", "livenessProbe", "readinessProbe", "jvmOptions", "affinity", "tolerations", "logging", "metrics", "tracing", "template", "externalConfiguration"})
public class KafkaConnectSpec
extends AbstractKafkaConnectSpec {
    private static final long serialVersionUID = 1L;
    public static final String FORBIDDEN_PREFIXES = "ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols";
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private String clientRackInitImage;
    private Rack rack;
    private String bootstrapServers;
    private KafkaConnectTls tls;
    private KafkaClientAuthentication authentication;
    private Build build;

    @Description(value="The Kafka Connect configuration. Properties with the following prefixes cannot be set: ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes (with the exception of: ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols).")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="The image of the init container used for initializing the `client.rack`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientRackInitImage() {
        return this.clientRackInitImage;
    }

    public void setClientRackInitImage(String brokerRackInitImage) {
        this.clientRackInitImage = brokerRackInitImage;
    }

    @Description(value="Configuration of the node label which will be used as the client.rack consumer configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Rack getRack() {
        return this.rack;
    }

    public void setRack(Rack rack) {
        this.rack = rack;
    }

    @Description(value="Bootstrap servers to connect to. This should be given as a comma separated list of _<hostname>_:\u200d_<port>_ pairs.")
    @JsonProperty(required=true)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Description(value="TLS configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaConnectTls getTls() {
        return this.tls;
    }

    public void setTls(KafkaConnectTls tls) {
        this.tls = tls;
    }

    @Description(value="Authentication configuration for Kafka Connect")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(KafkaClientAuthentication authentication) {
        this.authentication = authentication;
    }

    @Description(value="Configures how the Connect container image should be built. Optional.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnectSpec)) {
            return false;
        }
        KafkaConnectSpec other = (KafkaConnectSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$config = this.config;
        Map<String, Object> other$config = other.config;
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$clientRackInitImage = this.clientRackInitImage;
        String other$clientRackInitImage = other.clientRackInitImage;
        if (this$clientRackInitImage == null ? other$clientRackInitImage != null : !this$clientRackInitImage.equals(other$clientRackInitImage)) {
            return false;
        }
        Rack this$rack = this.rack;
        Rack other$rack = other.rack;
        if (this$rack == null ? other$rack != null : !((Object)this$rack).equals(other$rack)) {
            return false;
        }
        String this$bootstrapServers = this.bootstrapServers;
        String other$bootstrapServers = other.bootstrapServers;
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        KafkaConnectTls this$tls = this.tls;
        KafkaConnectTls other$tls = other.tls;
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        KafkaClientAuthentication this$authentication = this.authentication;
        KafkaClientAuthentication other$authentication = other.authentication;
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        Build this$build = this.build;
        Build other$build = other.build;
        return !(this$build == null ? other$build != null : !((Object)this$build).equals(other$build));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnectSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $config = this.config;
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $clientRackInitImage = this.clientRackInitImage;
        result = result * 59 + ($clientRackInitImage == null ? 43 : $clientRackInitImage.hashCode());
        Rack $rack = this.rack;
        result = result * 59 + ($rack == null ? 43 : ((Object)$rack).hashCode());
        String $bootstrapServers = this.bootstrapServers;
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        KafkaConnectTls $tls = this.tls;
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        KafkaClientAuthentication $authentication = this.authentication;
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        Build $build = this.build;
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        return result;
    }
}

