/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.build.Artifact;
import io.strimzi.api.kafka.model.connect.build.JarArtifact;
import io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.JarArtifactFluentImpl;
import io.strimzi.api.kafka.model.connect.build.Plugin;
import io.strimzi.api.kafka.model.connect.build.PluginFluent;
import io.strimzi.api.kafka.model.connect.build.TgzArtifact;
import io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.TgzArtifactFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PluginFluentImpl<A extends PluginFluent<A>>
extends BaseFluent<A>
implements PluginFluent<A> {
    private String name;
    private List<VisitableBuilder<? extends Artifact, ?>> artifacts;

    public PluginFluentImpl() {
    }

    public PluginFluentImpl(Plugin instance) {
        this.withName(instance.getName());
        this.withArtifacts(instance.getArtifacts());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A addToArtifacts(VisitableBuilder<? extends Artifact, ?> builder) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        this._visitables.get((Object)"artifacts").add(builder);
        this.artifacts.add(builder);
        return (A)this;
    }

    @Override
    public A addToArtifacts(int index, VisitableBuilder<? extends Artifact, ?> builder) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        this._visitables.get((Object)"artifacts").add(index, builder);
        this.artifacts.add(index, builder);
        return (A)this;
    }

    @Override
    public A addToArtifacts(int index, Artifact item) {
        if (item instanceof JarArtifact) {
            this.addToJarArtifactArtifacts(index, (JarArtifact)item);
        } else if (item instanceof TgzArtifact) {
            this.addToTgzArtifactArtifacts(index, (TgzArtifact)item);
        }
        return (A)this;
    }

    @Override
    public A setToArtifacts(int index, Artifact item) {
        if (item instanceof JarArtifact) {
            this.setToJarArtifactArtifacts(index, (JarArtifact)item);
        } else if (item instanceof TgzArtifact) {
            this.setToTgzArtifactArtifacts(index, (TgzArtifact)item);
        }
        return (A)this;
    }

    @Override
    public A addToArtifacts(Artifact ... items) {
        if (items != null && items.length > 0 && this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (Artifact item : items) {
            if (item instanceof JarArtifact) {
                this.addToJarArtifactArtifacts((JarArtifact)item);
                continue;
            }
            if (item instanceof TgzArtifact) {
                this.addToTgzArtifactArtifacts((TgzArtifact)item);
                continue;
            }
            VisitableBuilder builder = PluginFluentImpl.builderOf((Object)item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToArtifacts(Collection<Artifact> items) {
        if (items != null && items.size() > 0 && this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (Artifact item : items) {
            if (item instanceof JarArtifact) {
                this.addToJarArtifactArtifacts((JarArtifact)item);
                continue;
            }
            if (item instanceof TgzArtifact) {
                this.addToTgzArtifactArtifacts((TgzArtifact)item);
                continue;
            }
            VisitableBuilder builder = PluginFluentImpl.builderOf((Object)item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromArtifacts(VisitableBuilder<? extends Artifact, ?> builder) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        this._visitables.get((Object)"artifacts").remove(builder);
        this.artifacts.remove(builder);
        return (A)this;
    }

    @Override
    public A removeFromArtifacts(Artifact ... items) {
        for (Artifact item : items) {
            if (item instanceof JarArtifact) {
                this.removeFromJarArtifactArtifacts((JarArtifact)item);
                continue;
            }
            if (item instanceof TgzArtifact) {
                this.removeFromTgzArtifactArtifacts((TgzArtifact)item);
                continue;
            }
            VisitableBuilder builder = PluginFluentImpl.builderOf((Object)item);
            this._visitables.get((Object)"artifacts").remove(builder);
            this.artifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArtifacts(Collection<Artifact> items) {
        for (Artifact item : items) {
            if (item instanceof JarArtifact) {
                this.removeFromJarArtifactArtifacts((JarArtifact)item);
                continue;
            }
            if (item instanceof TgzArtifact) {
                this.removeFromTgzArtifactArtifacts((TgzArtifact)item);
                continue;
            }
            VisitableBuilder builder = PluginFluentImpl.builderOf((Object)item);
            this._visitables.get((Object)"artifacts").remove(builder);
            this.artifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Artifact> getArtifacts() {
        return PluginFluentImpl.build(this.artifacts);
    }

    @Override
    public List<Artifact> buildArtifacts() {
        return PluginFluentImpl.build(this.artifacts);
    }

    @Override
    public Artifact buildArtifact(int index) {
        return (Artifact)this.artifacts.get(index).build();
    }

    @Override
    public Artifact buildFirstArtifact() {
        return (Artifact)this.artifacts.get(0).build();
    }

    @Override
    public Artifact buildLastArtifact() {
        return (Artifact)this.artifacts.get(this.artifacts.size() - 1).build();
    }

    @Override
    public Artifact buildMatchingArtifact(Predicate<VisitableBuilder<? extends Artifact, ?>> predicate) {
        for (VisitableBuilder<? extends Artifact, ?> visitableBuilder : this.artifacts) {
            if (!predicate.apply(visitableBuilder).booleanValue()) continue;
            return (Artifact)visitableBuilder.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingArtifact(Predicate<VisitableBuilder<? extends Artifact, ?>> predicate) {
        for (VisitableBuilder<? extends Artifact, ?> visitableBuilder : this.artifacts) {
            if (!predicate.apply(visitableBuilder).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withArtifacts(List<Artifact> artifacts) {
        if (this.artifacts != null) {
            this._visitables.get((Object)"artifacts").removeAll(this.artifacts);
        }
        if (artifacts != null) {
            this.artifacts = new ArrayList();
            for (Artifact item : artifacts) {
                this.addToArtifacts(item);
            }
        } else {
            this.artifacts = null;
        }
        return (A)this;
    }

    @Override
    public A withArtifacts(Artifact ... artifacts) {
        if (this.artifacts != null) {
            this.artifacts.clear();
        }
        if (artifacts != null) {
            for (Artifact item : artifacts) {
                this.addToArtifacts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasArtifacts() {
        return this.artifacts != null && !this.artifacts.isEmpty();
    }

    @Override
    public A addToJarArtifactArtifacts(int index, JarArtifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        JarArtifactBuilder builder = new JarArtifactBuilder(item);
        this._visitables.get((Object)"artifacts").add(index >= 0 ? index : this._visitables.get((Object)"artifacts").size(), builder);
        this.artifacts.add(index >= 0 ? index : this.artifacts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToJarArtifactArtifacts(int index, JarArtifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        JarArtifactBuilder builder = new JarArtifactBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"artifacts").size()) {
            this._visitables.get((Object)"artifacts").add(builder);
        } else {
            this._visitables.get((Object)"artifacts").set(index, builder);
        }
        if (index < 0 || index >= this.artifacts.size()) {
            this.artifacts.add(builder);
        } else {
            this.artifacts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToJarArtifactArtifacts(JarArtifact ... items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (JarArtifact item : items) {
            JarArtifactBuilder builder = new JarArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToJarArtifactArtifacts(Collection<JarArtifact> items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (JarArtifact item : items) {
            JarArtifactBuilder builder = new JarArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromJarArtifactArtifacts(JarArtifact ... items) {
        for (JarArtifact item : items) {
            JarArtifactBuilder builder = new JarArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            if (this.artifacts == null) continue;
            this.artifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJarArtifactArtifacts(Collection<JarArtifact> items) {
        for (JarArtifact item : items) {
            JarArtifactBuilder builder = new JarArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            if (this.artifacts == null) continue;
            this.artifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromJarArtifactArtifacts(Predicate<VisitableBuilder<? extends Artifact, ?>> predicate) {
        if (this.artifacts == null) {
            return (A)this;
        }
        Iterator<VisitableBuilder<Artifact, ?>> each = this.artifacts.iterator();
        List visitables = this._visitables.get((Object)"artifacts");
        while (each.hasNext()) {
            VisitableBuilder<? extends Artifact, ?> builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public PluginFluent.JarArtifactArtifactsNested<A> addNewJarArtifactArtifact() {
        return new JarArtifactArtifactsNestedImpl();
    }

    @Override
    public PluginFluent.JarArtifactArtifactsNested<A> addNewJarArtifactArtifactLike(JarArtifact item) {
        return new JarArtifactArtifactsNestedImpl(-1, item);
    }

    @Override
    public PluginFluent.JarArtifactArtifactsNested<A> setNewJarArtifactArtifactLike(int index, JarArtifact item) {
        return new JarArtifactArtifactsNestedImpl(index, item);
    }

    @Override
    public A addToTgzArtifactArtifacts(int index, TgzArtifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        TgzArtifactBuilder builder = new TgzArtifactBuilder(item);
        this._visitables.get((Object)"artifacts").add(index >= 0 ? index : this._visitables.get((Object)"artifacts").size(), builder);
        this.artifacts.add(index >= 0 ? index : this.artifacts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTgzArtifactArtifacts(int index, TgzArtifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        TgzArtifactBuilder builder = new TgzArtifactBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"artifacts").size()) {
            this._visitables.get((Object)"artifacts").add(builder);
        } else {
            this._visitables.get((Object)"artifacts").set(index, builder);
        }
        if (index < 0 || index >= this.artifacts.size()) {
            this.artifacts.add(builder);
        } else {
            this.artifacts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTgzArtifactArtifacts(TgzArtifact ... items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (TgzArtifact item : items) {
            TgzArtifactBuilder builder = new TgzArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTgzArtifactArtifacts(Collection<TgzArtifact> items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (TgzArtifact item : items) {
            TgzArtifactBuilder builder = new TgzArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTgzArtifactArtifacts(TgzArtifact ... items) {
        for (TgzArtifact item : items) {
            TgzArtifactBuilder builder = new TgzArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            if (this.artifacts == null) continue;
            this.artifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTgzArtifactArtifacts(Collection<TgzArtifact> items) {
        for (TgzArtifact item : items) {
            TgzArtifactBuilder builder = new TgzArtifactBuilder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            if (this.artifacts == null) continue;
            this.artifacts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTgzArtifactArtifacts(Predicate<VisitableBuilder<? extends Artifact, ?>> predicate) {
        if (this.artifacts == null) {
            return (A)this;
        }
        Iterator<VisitableBuilder<Artifact, ?>> each = this.artifacts.iterator();
        List visitables = this._visitables.get((Object)"artifacts");
        while (each.hasNext()) {
            VisitableBuilder<? extends Artifact, ?> builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public PluginFluent.TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifact() {
        return new TgzArtifactArtifactsNestedImpl();
    }

    @Override
    public PluginFluent.TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifactLike(TgzArtifact item) {
        return new TgzArtifactArtifactsNestedImpl(-1, item);
    }

    @Override
    public PluginFluent.TgzArtifactArtifactsNested<A> setNewTgzArtifactArtifactLike(int index, TgzArtifact item) {
        return new TgzArtifactArtifactsNestedImpl(index, item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginFluentImpl that = (PluginFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.artifacts != null ? !this.artifacts.equals(that.artifacts) : that.artifacts != null);
    }

    public class TgzArtifactArtifactsNestedImpl<N>
    extends TgzArtifactFluentImpl<PluginFluent.TgzArtifactArtifactsNested<N>>
    implements PluginFluent.TgzArtifactArtifactsNested<N>,
    Nested<N> {
        private final TgzArtifactBuilder builder;
        private final int index;

        TgzArtifactArtifactsNestedImpl(int index, TgzArtifact item) {
            this.index = index;
            this.builder = new TgzArtifactBuilder(this, item);
        }

        TgzArtifactArtifactsNestedImpl() {
            this.index = -1;
            this.builder = new TgzArtifactBuilder(this);
        }

        @Override
        public N and() {
            return (N)PluginFluentImpl.this.setToTgzArtifactArtifacts(this.index, this.builder.build());
        }

        @Override
        public N endTgzArtifactArtifact() {
            return this.and();
        }
    }

    public class JarArtifactArtifactsNestedImpl<N>
    extends JarArtifactFluentImpl<PluginFluent.JarArtifactArtifactsNested<N>>
    implements PluginFluent.JarArtifactArtifactsNested<N>,
    Nested<N> {
        private final JarArtifactBuilder builder;
        private final int index;

        JarArtifactArtifactsNestedImpl(int index, JarArtifact item) {
            this.index = index;
            this.builder = new JarArtifactBuilder(this, item);
        }

        JarArtifactArtifactsNestedImpl() {
            this.index = -1;
            this.builder = new JarArtifactBuilder(this);
        }

        @Override
        public N and() {
            return (N)PluginFluentImpl.this.setToJarArtifactArtifacts(this.index, this.builder.build());
        }

        @Override
        public N endJarArtifactArtifact() {
            return this.and();
        }
    }
}

