/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.listener.IngressListenerBootstrapConfiguration;
import io.strimzi.api.kafka.model.listener.IngressListenerBootstrapConfigurationBuilder;
import io.strimzi.api.kafka.model.listener.IngressListenerBootstrapConfigurationFluentImpl;
import io.strimzi.api.kafka.model.listener.IngressListenerBrokerConfiguration;
import io.strimzi.api.kafka.model.listener.IngressListenerBrokerConfigurationBuilder;
import io.strimzi.api.kafka.model.listener.IngressListenerBrokerConfigurationFluentImpl;
import io.strimzi.api.kafka.model.listener.IngressListenerConfiguration;
import io.strimzi.api.kafka.model.listener.IngressListenerConfigurationFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalConfigurationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IngressListenerConfigurationFluentImpl<A extends IngressListenerConfigurationFluent<A>>
extends KafkaListenerExternalConfigurationFluentImpl<A>
implements IngressListenerConfigurationFluent<A> {
    private IngressListenerBootstrapConfigurationBuilder bootstrap;
    private List<IngressListenerBrokerConfigurationBuilder> brokers;

    public IngressListenerConfigurationFluentImpl() {
    }

    public IngressListenerConfigurationFluentImpl(IngressListenerConfiguration instance) {
        this.withBootstrap(instance.getBootstrap());
        this.withBrokers(instance.getBrokers());
        this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
    }

    @Override
    @Deprecated
    public IngressListenerBootstrapConfiguration getBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    @Override
    public IngressListenerBootstrapConfiguration buildBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    @Override
    public A withBootstrap(IngressListenerBootstrapConfiguration bootstrap) {
        this._visitables.get((Object)"bootstrap").remove(this.bootstrap);
        if (bootstrap != null) {
            this.bootstrap = new IngressListenerBootstrapConfigurationBuilder(bootstrap);
            this._visitables.get((Object)"bootstrap").add(this.bootstrap);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    @Override
    public IngressListenerConfigurationFluent.BootstrapNested<A> withNewBootstrap() {
        return new BootstrapNestedImpl();
    }

    @Override
    public IngressListenerConfigurationFluent.BootstrapNested<A> withNewBootstrapLike(IngressListenerBootstrapConfiguration item) {
        return new BootstrapNestedImpl(item);
    }

    @Override
    public IngressListenerConfigurationFluent.BootstrapNested<A> editBootstrap() {
        return this.withNewBootstrapLike(this.getBootstrap());
    }

    @Override
    public IngressListenerConfigurationFluent.BootstrapNested<A> editOrNewBootstrap() {
        return this.withNewBootstrapLike(this.getBootstrap() != null ? this.getBootstrap() : new IngressListenerBootstrapConfigurationBuilder().build());
    }

    @Override
    public IngressListenerConfigurationFluent.BootstrapNested<A> editOrNewBootstrapLike(IngressListenerBootstrapConfiguration item) {
        return this.withNewBootstrapLike(this.getBootstrap() != null ? this.getBootstrap() : item);
    }

    @Override
    public A addToBrokers(int index, IngressListenerBrokerConfiguration item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();
        }
        IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);
        this._visitables.get((Object)"brokers").add(index >= 0 ? index : this._visitables.get((Object)"brokers").size(), builder);
        this.brokers.add(index >= 0 ? index : this.brokers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToBrokers(int index, IngressListenerBrokerConfiguration item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();
        }
        IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"brokers").size()) {
            this._visitables.get((Object)"brokers").add(builder);
        } else {
            this._visitables.get((Object)"brokers").set(index, builder);
        }
        if (index < 0 || index >= this.brokers.size()) {
            this.brokers.add(builder);
        } else {
            this.brokers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBrokers(IngressListenerBrokerConfiguration ... items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();
        }
        for (IngressListenerBrokerConfiguration item : items) {
            IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBrokers(Collection<IngressListenerBrokerConfiguration> items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();
        }
        for (IngressListenerBrokerConfiguration item : items) {
            IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBrokers(IngressListenerBrokerConfiguration ... items) {
        for (IngressListenerBrokerConfiguration item : items) {
            IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);
            this._visitables.get((Object)"brokers").remove(builder);
            if (this.brokers == null) continue;
            this.brokers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBrokers(Collection<IngressListenerBrokerConfiguration> items) {
        for (IngressListenerBrokerConfiguration item : items) {
            IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);
            this._visitables.get((Object)"brokers").remove(builder);
            if (this.brokers == null) continue;
            this.brokers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromBrokers(Predicate<IngressListenerBrokerConfigurationBuilder> predicate) {
        if (this.brokers == null) {
            return (A)this;
        }
        Iterator<IngressListenerBrokerConfigurationBuilder> each = this.brokers.iterator();
        List visitables = this._visitables.get((Object)"brokers");
        while (each.hasNext()) {
            IngressListenerBrokerConfigurationBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressListenerBrokerConfiguration> getBrokers() {
        return IngressListenerConfigurationFluentImpl.build(this.brokers);
    }

    @Override
    public List<IngressListenerBrokerConfiguration> buildBrokers() {
        return IngressListenerConfigurationFluentImpl.build(this.brokers);
    }

    @Override
    public IngressListenerBrokerConfiguration buildBroker(int index) {
        return this.brokers.get(index).build();
    }

    @Override
    public IngressListenerBrokerConfiguration buildFirstBroker() {
        return this.brokers.get(0).build();
    }

    @Override
    public IngressListenerBrokerConfiguration buildLastBroker() {
        return this.brokers.get(this.brokers.size() - 1).build();
    }

    @Override
    public IngressListenerBrokerConfiguration buildMatchingBroker(Predicate<IngressListenerBrokerConfigurationBuilder> predicate) {
        for (IngressListenerBrokerConfigurationBuilder item : this.brokers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBroker(Predicate<IngressListenerBrokerConfigurationBuilder> predicate) {
        for (IngressListenerBrokerConfigurationBuilder item : this.brokers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBrokers(List<IngressListenerBrokerConfiguration> brokers) {
        if (this.brokers != null) {
            this._visitables.get((Object)"brokers").removeAll(this.brokers);
        }
        if (brokers != null) {
            this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();
            for (IngressListenerBrokerConfiguration item : brokers) {
                this.addToBrokers(item);
            }
        } else {
            this.brokers = null;
        }
        return (A)this;
    }

    @Override
    public A withBrokers(IngressListenerBrokerConfiguration ... brokers) {
        if (this.brokers != null) {
            this.brokers.clear();
        }
        if (brokers != null) {
            for (IngressListenerBrokerConfiguration item : brokers) {
                this.addToBrokers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBrokers() {
        return this.brokers != null && !this.brokers.isEmpty();
    }

    @Override
    public IngressListenerConfigurationFluent.BrokersNested<A> addNewBroker() {
        return new BrokersNestedImpl();
    }

    @Override
    public IngressListenerConfigurationFluent.BrokersNested<A> addNewBrokerLike(IngressListenerBrokerConfiguration item) {
        return new BrokersNestedImpl(-1, item);
    }

    @Override
    public IngressListenerConfigurationFluent.BrokersNested<A> setNewBrokerLike(int index, IngressListenerBrokerConfiguration item) {
        return new BrokersNestedImpl(index, item);
    }

    @Override
    public IngressListenerConfigurationFluent.BrokersNested<A> editBroker(int index) {
        if (this.brokers.size() <= index) {
            throw new RuntimeException("Can't edit brokers. Index exceeds size.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    @Override
    public IngressListenerConfigurationFluent.BrokersNested<A> editFirstBroker() {
        if (this.brokers.size() == 0) {
            throw new RuntimeException("Can't edit first brokers. The list is empty.");
        }
        return this.setNewBrokerLike(0, this.buildBroker(0));
    }

    @Override
    public IngressListenerConfigurationFluent.BrokersNested<A> editLastBroker() {
        int index = this.brokers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last brokers. The list is empty.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    @Override
    public IngressListenerConfigurationFluent.BrokersNested<A> editMatchingBroker(Predicate<IngressListenerBrokerConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.brokers.size(); ++i) {
            if (!predicate.apply((Object)this.brokers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching brokers. No match found.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressListenerConfigurationFluentImpl that = (IngressListenerConfigurationFluentImpl)o;
        if (this.bootstrap != null ? !this.bootstrap.equals(that.bootstrap) : that.bootstrap != null) {
            return false;
        }
        return !(this.brokers != null ? !this.brokers.equals(that.brokers) : that.brokers != null);
    }

    public class BrokersNestedImpl<N>
    extends IngressListenerBrokerConfigurationFluentImpl<IngressListenerConfigurationFluent.BrokersNested<N>>
    implements IngressListenerConfigurationFluent.BrokersNested<N>,
    Nested<N> {
        private final IngressListenerBrokerConfigurationBuilder builder;
        private final int index;

        BrokersNestedImpl(int index, IngressListenerBrokerConfiguration item) {
            this.index = index;
            this.builder = new IngressListenerBrokerConfigurationBuilder(this, item);
        }

        BrokersNestedImpl() {
            this.index = -1;
            this.builder = new IngressListenerBrokerConfigurationBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressListenerConfigurationFluentImpl.this.setToBrokers(this.index, this.builder.build());
        }

        @Override
        public N endBroker() {
            return this.and();
        }
    }

    public class BootstrapNestedImpl<N>
    extends IngressListenerBootstrapConfigurationFluentImpl<IngressListenerConfigurationFluent.BootstrapNested<N>>
    implements IngressListenerConfigurationFluent.BootstrapNested<N>,
    Nested<N> {
        private final IngressListenerBootstrapConfigurationBuilder builder;

        BootstrapNestedImpl(IngressListenerBootstrapConfiguration item) {
            this.builder = new IngressListenerBootstrapConfigurationBuilder(this, item);
        }

        BootstrapNestedImpl() {
            this.builder = new IngressListenerBootstrapConfigurationBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressListenerConfigurationFluentImpl.this.withBootstrap(this.builder.build());
        }

        @Override
        public N endBootstrap() {
            return this.and();
        }
    }
}

