/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.vertx.core.cli.annotations.DefaultValue;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KafkaListenerAuthenticationOAuth
extends KafkaListenerAuthentication {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_OAUTH = "oauth";
    public static final int DEFAULT_JWKS_EXPIRY_SECONDS = 360;
    public static final int DEFAULT_JWKS_REFRESH_SECONDS = 300;
    private String clientId;
    private GenericSecretSource clientSecret;
    private String validIssuerUri;
    private boolean checkIssuer = true;
    private String jwksEndpointUri;
    private Integer jwksRefreshSeconds;
    private Integer jwksMinRefreshPauseSeconds;
    private Integer jwksExpirySeconds;
    private String introspectionEndpointUri;
    private String userNameClaim;
    private String fallbackUserNameClaim;
    private String fallbackUserNamePrefix;
    private String userInfoEndpointUri;
    private boolean checkAccessTokenType = true;
    private String validTokenType;
    private boolean accessTokenIsJwt = true;
    private List<CertSecretSource> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification = false;
    private boolean enableECDSA = false;
    private Integer maxSecondsWithoutReauthentication;

    @Override
    @Description(value="Must be `oauth`")
    public String getType() {
        return TYPE_OAUTH;
    }

    @Description(value="OAuth Client ID which the Kafka broker can use to authenticate against the authorization server and use the introspect endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Description(value="Link to Kubernetes Secret containing the OAuth client secret which the Kafka broker can use to authenticate against the authorization server and use the introspect endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(GenericSecretSource clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Description(value="URI of the token issuer used for authentication.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValidIssuerUri() {
        return this.validIssuerUri;
    }

    public void setValidIssuerUri(String validIssuerUri) {
        this.validIssuerUri = validIssuerUri;
    }

    @Description(value="Enable or disable issuer checking. By default issuer is checked using the value configured by `validIssuerUri`. Default value is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isCheckIssuer() {
        return this.checkIssuer;
    }

    public void setCheckIssuer(boolean checkIssuer) {
        this.checkIssuer = checkIssuer;
    }

    @Description(value="URI of the JWKS certificate endpoint, which can be used for local JWT validation.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    public void setJwksEndpointUri(String jwksEndpointUri) {
        this.jwksEndpointUri = jwksEndpointUri;
    }

    @Description(value="Configures how often are the JWKS certificates refreshed. The refresh interval has to be at least 60 seconds shorter then the expiry interval specified in `jwksExpirySeconds`. Defaults to 300 seconds.")
    @Minimum(value=1)
    @DefaultValue(value="300")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getJwksRefreshSeconds() {
        return this.jwksRefreshSeconds;
    }

    public void setJwksRefreshSeconds(Integer jwksRefreshSeconds) {
        this.jwksRefreshSeconds = jwksRefreshSeconds;
    }

    @Description(value="The minimum pause between two consecutive refreshes. When an unknown signing key is encountered the refresh is scheduled immediately, but will always wait for this minimum pause. Defaults to 1 second.")
    @Minimum(value=0)
    @DefaultValue(value="1")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getJwksMinRefreshPauseSeconds() {
        return this.jwksMinRefreshPauseSeconds;
    }

    public void setJwksMinRefreshPauseSeconds(Integer jwksMinRefreshPauseSeconds) {
        this.jwksMinRefreshPauseSeconds = jwksMinRefreshPauseSeconds;
    }

    @Description(value="Configures how often are the JWKS certificates considered valid. The expiry interval has to be at least 60 seconds longer then the refresh interval specified in `jwksRefreshSeconds`. Defaults to 360 seconds.")
    @Minimum(value=1)
    @DefaultValue(value="360")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getJwksExpirySeconds() {
        return this.jwksExpirySeconds;
    }

    public void setJwksExpirySeconds(Integer jwksExpirySeconds) {
        this.jwksExpirySeconds = jwksExpirySeconds;
    }

    @Description(value="URI of the token introspection endpoint which can be used to validate opaque non-JWT tokens.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    public void setIntrospectionEndpointUri(String introspectionEndpointUri) {
        this.introspectionEndpointUri = introspectionEndpointUri;
    }

    @Description(value="Name of the claim from the JWT authentication token, Introspection Endpoint response or User Info Endpoint response which will be used to extract the user id. Defaults to `sub`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUserNameClaim() {
        return this.userNameClaim;
    }

    public void setUserNameClaim(String userNameClaim) {
        this.userNameClaim = userNameClaim;
    }

    @Description(value="The fallback username claim to be used for the user id if the claim specified by `userNameClaim` is not present. This is useful when `client_credentials` authentication only results in the client id being provided in another claim. It only takes effect if `userNameClaim` is set.")
    public String getFallbackUserNameClaim() {
        return this.fallbackUserNameClaim;
    }

    public void setFallbackUserNameClaim(String fallbackUserNameClaim) {
        this.fallbackUserNameClaim = fallbackUserNameClaim;
    }

    @Description(value="The prefix to use with the value of `fallbackUserNameClaim` to construct the user id. This only takes effect if `fallbackUserNameClaim` is true, and the value is present for the claim. Mapping usernames and client ids into the same user id space is useful in preventing name collisions.")
    public String getFallbackUserNamePrefix() {
        return this.fallbackUserNamePrefix;
    }

    public void setFallbackUserNamePrefix(String fallbackUserNamePrefix) {
        this.fallbackUserNamePrefix = fallbackUserNamePrefix;
    }

    @Description(value="Configure whether the access token type check is performed or not. This should be set to `false` if the authorization server does not include 'typ' claim in JWT token. Defaults to `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isCheckAccessTokenType() {
        return this.checkAccessTokenType;
    }

    public void setCheckAccessTokenType(boolean checkAccessTokenType) {
        this.checkAccessTokenType = checkAccessTokenType;
    }

    @Description(value="Valid value for the `token_type` attribute returned by the Introspection Endpoint. No default value, and not checked by default.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getValidTokenType() {
        return this.validTokenType;
    }

    public void setValidTokenType(String validTokenType) {
        this.validTokenType = validTokenType;
    }

    @Description(value="Configure whether the access token is treated as JWT. This must be set to `false` if the authorization server returns opaque tokens. Defaults to `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public void setAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
    }

    @Description(value="Trusted certificates for TLS connection to the OAuth server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return this.tlsTrustedCertificates;
    }

    public void setTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        this.tlsTrustedCertificates = tlsTrustedCertificates;
    }

    @Description(value="Enable or disable TLS hostname verification. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public void setDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
    }

    @Description(value="Enable or disable ECDSA support by installing BouncyCastle crypto provider. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isEnableECDSA() {
        return this.enableECDSA;
    }

    public void setEnableECDSA(boolean enableECDSA) {
        this.enableECDSA = enableECDSA;
    }

    @Description(value="URI of the User Info Endpoint to use as a fallback to obtaining the user id when the Introspection Endpoint does not return information that can be used for the user id. ")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getUserInfoEndpointUri() {
        return this.userInfoEndpointUri;
    }

    public void setUserInfoEndpointUri(String userInfoEndpointUri) {
        this.userInfoEndpointUri = userInfoEndpointUri;
    }

    @Description(value="Maximum number of seconds the authenticated session remains valid without re-authentication. This enables Apache Kafka re-authentication feature, and causes sessions to expire when the access token expires. If the access token expires before max time or if max time is reached, the client has to re-authenticate, otherwise the server will drop the connection. Not set by default - the authenticated session does not expire when the access token expires.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxSecondsWithoutReauthentication() {
        return this.maxSecondsWithoutReauthentication;
    }

    public void setMaxSecondsWithoutReauthentication(Integer maxSecondsWithoutReauthentication) {
        this.maxSecondsWithoutReauthentication = maxSecondsWithoutReauthentication;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaListenerAuthenticationOAuth)) {
            return false;
        }
        KafkaListenerAuthenticationOAuth other = (KafkaListenerAuthenticationOAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        GenericSecretSource this$clientSecret = this.getClientSecret();
        GenericSecretSource other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !((Object)this$clientSecret).equals(other$clientSecret)) {
            return false;
        }
        String this$validIssuerUri = this.getValidIssuerUri();
        String other$validIssuerUri = other.getValidIssuerUri();
        if (this$validIssuerUri == null ? other$validIssuerUri != null : !this$validIssuerUri.equals(other$validIssuerUri)) {
            return false;
        }
        if (this.isCheckIssuer() != other.isCheckIssuer()) {
            return false;
        }
        String this$jwksEndpointUri = this.getJwksEndpointUri();
        String other$jwksEndpointUri = other.getJwksEndpointUri();
        if (this$jwksEndpointUri == null ? other$jwksEndpointUri != null : !this$jwksEndpointUri.equals(other$jwksEndpointUri)) {
            return false;
        }
        Integer this$jwksRefreshSeconds = this.getJwksRefreshSeconds();
        Integer other$jwksRefreshSeconds = other.getJwksRefreshSeconds();
        if (this$jwksRefreshSeconds == null ? other$jwksRefreshSeconds != null : !((Object)this$jwksRefreshSeconds).equals(other$jwksRefreshSeconds)) {
            return false;
        }
        Integer this$jwksMinRefreshPauseSeconds = this.getJwksMinRefreshPauseSeconds();
        Integer other$jwksMinRefreshPauseSeconds = other.getJwksMinRefreshPauseSeconds();
        if (this$jwksMinRefreshPauseSeconds == null ? other$jwksMinRefreshPauseSeconds != null : !((Object)this$jwksMinRefreshPauseSeconds).equals(other$jwksMinRefreshPauseSeconds)) {
            return false;
        }
        Integer this$jwksExpirySeconds = this.getJwksExpirySeconds();
        Integer other$jwksExpirySeconds = other.getJwksExpirySeconds();
        if (this$jwksExpirySeconds == null ? other$jwksExpirySeconds != null : !((Object)this$jwksExpirySeconds).equals(other$jwksExpirySeconds)) {
            return false;
        }
        String this$introspectionEndpointUri = this.getIntrospectionEndpointUri();
        String other$introspectionEndpointUri = other.getIntrospectionEndpointUri();
        if (this$introspectionEndpointUri == null ? other$introspectionEndpointUri != null : !this$introspectionEndpointUri.equals(other$introspectionEndpointUri)) {
            return false;
        }
        String this$userNameClaim = this.getUserNameClaim();
        String other$userNameClaim = other.getUserNameClaim();
        if (this$userNameClaim == null ? other$userNameClaim != null : !this$userNameClaim.equals(other$userNameClaim)) {
            return false;
        }
        String this$fallbackUserNameClaim = this.getFallbackUserNameClaim();
        String other$fallbackUserNameClaim = other.getFallbackUserNameClaim();
        if (this$fallbackUserNameClaim == null ? other$fallbackUserNameClaim != null : !this$fallbackUserNameClaim.equals(other$fallbackUserNameClaim)) {
            return false;
        }
        String this$fallbackUserNamePrefix = this.getFallbackUserNamePrefix();
        String other$fallbackUserNamePrefix = other.getFallbackUserNamePrefix();
        if (this$fallbackUserNamePrefix == null ? other$fallbackUserNamePrefix != null : !this$fallbackUserNamePrefix.equals(other$fallbackUserNamePrefix)) {
            return false;
        }
        String this$userInfoEndpointUri = this.getUserInfoEndpointUri();
        String other$userInfoEndpointUri = other.getUserInfoEndpointUri();
        if (this$userInfoEndpointUri == null ? other$userInfoEndpointUri != null : !this$userInfoEndpointUri.equals(other$userInfoEndpointUri)) {
            return false;
        }
        if (this.isCheckAccessTokenType() != other.isCheckAccessTokenType()) {
            return false;
        }
        String this$validTokenType = this.getValidTokenType();
        String other$validTokenType = other.getValidTokenType();
        if (this$validTokenType == null ? other$validTokenType != null : !this$validTokenType.equals(other$validTokenType)) {
            return false;
        }
        if (this.isAccessTokenIsJwt() != other.isAccessTokenIsJwt()) {
            return false;
        }
        List<CertSecretSource> this$tlsTrustedCertificates = this.getTlsTrustedCertificates();
        List<CertSecretSource> other$tlsTrustedCertificates = other.getTlsTrustedCertificates();
        if (this$tlsTrustedCertificates == null ? other$tlsTrustedCertificates != null : !((Object)this$tlsTrustedCertificates).equals(other$tlsTrustedCertificates)) {
            return false;
        }
        if (this.isDisableTlsHostnameVerification() != other.isDisableTlsHostnameVerification()) {
            return false;
        }
        if (this.isEnableECDSA() != other.isEnableECDSA()) {
            return false;
        }
        Integer this$maxSecondsWithoutReauthentication = this.getMaxSecondsWithoutReauthentication();
        Integer other$maxSecondsWithoutReauthentication = other.getMaxSecondsWithoutReauthentication();
        return !(this$maxSecondsWithoutReauthentication == null ? other$maxSecondsWithoutReauthentication != null : !((Object)this$maxSecondsWithoutReauthentication).equals(other$maxSecondsWithoutReauthentication));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaListenerAuthenticationOAuth;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        GenericSecretSource $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : ((Object)$clientSecret).hashCode());
        String $validIssuerUri = this.getValidIssuerUri();
        result = result * 59 + ($validIssuerUri == null ? 43 : $validIssuerUri.hashCode());
        result = result * 59 + (this.isCheckIssuer() ? 79 : 97);
        String $jwksEndpointUri = this.getJwksEndpointUri();
        result = result * 59 + ($jwksEndpointUri == null ? 43 : $jwksEndpointUri.hashCode());
        Integer $jwksRefreshSeconds = this.getJwksRefreshSeconds();
        result = result * 59 + ($jwksRefreshSeconds == null ? 43 : ((Object)$jwksRefreshSeconds).hashCode());
        Integer $jwksMinRefreshPauseSeconds = this.getJwksMinRefreshPauseSeconds();
        result = result * 59 + ($jwksMinRefreshPauseSeconds == null ? 43 : ((Object)$jwksMinRefreshPauseSeconds).hashCode());
        Integer $jwksExpirySeconds = this.getJwksExpirySeconds();
        result = result * 59 + ($jwksExpirySeconds == null ? 43 : ((Object)$jwksExpirySeconds).hashCode());
        String $introspectionEndpointUri = this.getIntrospectionEndpointUri();
        result = result * 59 + ($introspectionEndpointUri == null ? 43 : $introspectionEndpointUri.hashCode());
        String $userNameClaim = this.getUserNameClaim();
        result = result * 59 + ($userNameClaim == null ? 43 : $userNameClaim.hashCode());
        String $fallbackUserNameClaim = this.getFallbackUserNameClaim();
        result = result * 59 + ($fallbackUserNameClaim == null ? 43 : $fallbackUserNameClaim.hashCode());
        String $fallbackUserNamePrefix = this.getFallbackUserNamePrefix();
        result = result * 59 + ($fallbackUserNamePrefix == null ? 43 : $fallbackUserNamePrefix.hashCode());
        String $userInfoEndpointUri = this.getUserInfoEndpointUri();
        result = result * 59 + ($userInfoEndpointUri == null ? 43 : $userInfoEndpointUri.hashCode());
        result = result * 59 + (this.isCheckAccessTokenType() ? 79 : 97);
        String $validTokenType = this.getValidTokenType();
        result = result * 59 + ($validTokenType == null ? 43 : $validTokenType.hashCode());
        result = result * 59 + (this.isAccessTokenIsJwt() ? 79 : 97);
        List<CertSecretSource> $tlsTrustedCertificates = this.getTlsTrustedCertificates();
        result = result * 59 + ($tlsTrustedCertificates == null ? 43 : ((Object)$tlsTrustedCertificates).hashCode());
        result = result * 59 + (this.isDisableTlsHostnameVerification() ? 79 : 97);
        result = result * 59 + (this.isEnableECDSA() ? 79 : 97);
        Integer $maxSecondsWithoutReauthentication = this.getMaxSecondsWithoutReauthentication();
        result = result * 59 + ($maxSecondsWithoutReauthentication == null ? 43 : ((Object)$maxSecondsWithoutReauthentication).hashCode());
        return result;
    }
}

