/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalIngress;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalLoadBalancer;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalNodePort;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalRoute;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="route", value=KafkaListenerExternalRoute.class), @JsonSubTypes.Type(name="loadbalancer", value=KafkaListenerExternalLoadBalancer.class), @JsonSubTypes.Type(name="nodeport", value=KafkaListenerExternalNodePort.class), @JsonSubTypes.Type(name="ingress", value=KafkaListenerExternalIngress.class)})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class KafkaListenerExternal
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> additionalProperties;

    @Description(value="Type of the external listener. Currently the supported types are `route`, `loadbalancer`, and `nodeport`. \n\n* `route` type uses OpenShift Routes to expose Kafka.* `loadbalancer` type uses LoadBalancer type services to expose Kafka.* `nodeport` type uses NodePort type services to expose Kafka.")
    public abstract String getType();

    @Description(value="Authentication configuration for Kafka brokers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authentication")
    public abstract KafkaListenerAuthentication getAuth();

    public abstract void setAuth(KafkaListenerAuthentication var1);

    @Description(value="List of peers which should be able to connect to this listener. Peers in this list are combined using a logical OR operation. If this field is empty or missing, all connections will be allowed for this listener. If this field is present and contains at least one item, the listener only allows the traffic which matches at least one item in this list.")
    @KubeLink(group="networking.k8s.io", version="v1", kind="networkpolicypeer")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract List<NetworkPolicyPeer> getNetworkPolicyPeers();

    public abstract void setNetworkPolicyPeers(List<NetworkPolicyPeer> var1);

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaListenerExternal)) {
            return false;
        }
        KafkaListenerExternal other = (KafkaListenerExternal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaListenerExternal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

