/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.listener.ExternalListenerBootstrapOverrideFluentImpl;
import io.strimzi.api.kafka.model.listener.NodePortListenerBootstrapOverride;
import io.strimzi.api.kafka.model.listener.NodePortListenerBootstrapOverrideFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class NodePortListenerBootstrapOverrideFluentImpl<A extends NodePortListenerBootstrapOverrideFluent<A>>
extends ExternalListenerBootstrapOverrideFluentImpl<A>
implements NodePortListenerBootstrapOverrideFluent<A> {
    private Integer nodePort;
    private Map<String, String> dnsAnnotations;

    public NodePortListenerBootstrapOverrideFluentImpl() {
    }

    public NodePortListenerBootstrapOverrideFluentImpl(NodePortListenerBootstrapOverride instance) {
        this.withNodePort(instance.getNodePort());
        this.withDnsAnnotations(instance.getDnsAnnotations());
        this.withAddress(instance.getAddress());
    }

    @Override
    public Integer getNodePort() {
        return this.nodePort;
    }

    @Override
    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)this;
    }

    @Override
    public Boolean hasNodePort() {
        return this.nodePort != null;
    }

    @Override
    public A addToDnsAnnotations(String key, String value) {
        if (this.dnsAnnotations == null && key != null && value != null) {
            this.dnsAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.dnsAnnotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDnsAnnotations(Map<String, String> map) {
        if (this.dnsAnnotations == null && map != null) {
            this.dnsAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.dnsAnnotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsAnnotations(String key) {
        if (this.dnsAnnotations == null) {
            return (A)this;
        }
        if (key != null && this.dnsAnnotations != null) {
            this.dnsAnnotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsAnnotations(Map<String, String> map) {
        if (this.dnsAnnotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.dnsAnnotations == null) continue;
                this.dnsAnnotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getDnsAnnotations() {
        return this.dnsAnnotations;
    }

    @Override
    public A withDnsAnnotations(Map<String, String> dnsAnnotations) {
        this.dnsAnnotations = dnsAnnotations == null ? null : new LinkedHashMap<String, String>(dnsAnnotations);
        return (A)this;
    }

    @Override
    public Boolean hasDnsAnnotations() {
        return this.dnsAnnotations != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodePortListenerBootstrapOverrideFluentImpl that = (NodePortListenerBootstrapOverrideFluentImpl)o;
        if (this.nodePort != null ? !this.nodePort.equals(that.nodePort) : that.nodePort != null) {
            return false;
        }
        return !(this.dnsAnnotations != null ? !this.dnsAnnotations.equals(that.dnsAnnotations) : that.dnsAnnotations != null);
    }
}

