/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener.arraylistener;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.strimzi.api.kafka.model.listener.KafkaListeners;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.ListenersConvertor;
import io.strimzi.crdgenerator.annotations.Alternation;
import io.strimzi.crdgenerator.annotations.Alternative;
import io.strimzi.crdgenerator.annotations.MinimumItems;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Alternation
public class ArrayOrObjectKafkaListeners
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<GenericKafkaListener> genericKafkaListeners;
    private final KafkaListeners kafkaListeners;

    ArrayOrObjectKafkaListeners(List<GenericKafkaListener> genericKafkaListeners, KafkaListeners kafkaListeners) {
        this.genericKafkaListeners = genericKafkaListeners;
        this.kafkaListeners = kafkaListeners;
    }

    @Deprecated
    public ArrayOrObjectKafkaListeners(KafkaListeners kafkaListeners) {
        this(null, kafkaListeners);
    }

    public ArrayOrObjectKafkaListeners(List<GenericKafkaListener> genericKafkaListeners) {
        this(genericKafkaListeners, null);
    }

    @Alternative(apiVersion="v1alpha1+")
    @MinimumItems(value=1)
    public List<GenericKafkaListener> getGenericKafkaListeners() {
        return this.genericKafkaListeners;
    }

    @Alternative(apiVersion="v1alpha1-v1beta1")
    public KafkaListeners getKafkaListeners() {
        return this.kafkaListeners;
    }

    public List<GenericKafkaListener> newOrConverted() {
        if (this.genericKafkaListeners != null) {
            return this.genericKafkaListeners;
        }
        return ListenersConvertor.convertToNewFormat(this.kafkaListeners);
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
    public static class Deserializer
    extends JsonDeserializer<ArrayOrObjectKafkaListeners> {
        public ArrayOrObjectKafkaListeners deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            ObjectCodec oc = jsonParser.getCodec();
            if (jsonParser.currentToken() == JsonToken.START_ARRAY) {
                return new ArrayOrObjectKafkaListeners((List)oc.readValue(jsonParser, (TypeReference)new TypeReference<List<GenericKafkaListener>>(){}));
            }
            if (jsonParser.currentToken() == JsonToken.START_OBJECT) {
                return new ArrayOrObjectKafkaListeners((KafkaListeners)oc.readValue(jsonParser, (TypeReference)new TypeReference<KafkaListeners>(){}));
            }
            throw new RuntimeException("Failed to deserialize ArrayOrObjectKafkaListeners. Please check .spec.kafka.listeners configuration.");
        }
    }

    public static class Serializer
    extends JsonSerializer<ArrayOrObjectKafkaListeners> {
        public void serialize(ArrayOrObjectKafkaListeners value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (value == null) {
                generator.writeNull();
                return;
            }
            if (value.genericKafkaListeners != null) {
                generator.writeObject(value.genericKafkaListeners);
            } else if (value.kafkaListeners != null) {
                generator.writeObject((Object)value.kafkaListeners);
            } else {
                generator.writeNull();
            }
        }
    }
}

