/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener.arraylistener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.listener.NodeAddressType;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrap;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker;
import io.strimzi.api.kafka.model.template.ExternalTrafficPolicy;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonPropertyOrder(value={"brokerCertChainAndKey", "ingressClass", "preferredAddressType", "externalTrafficPolicy", "loadBalancerSourceRanges", "bootstrap", "brokers"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericKafkaListenerConfiguration
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    private CertAndKeySecretSource brokerCertChainAndKey;
    private String ingressClass;
    private NodeAddressType preferredNodePortAddressType;
    private ExternalTrafficPolicy externalTrafficPolicy;
    private List<String> loadBalancerSourceRanges = new ArrayList<String>(0);
    private Boolean useServiceDnsDomain;
    private GenericKafkaListenerConfigurationBootstrap bootstrap;
    private List<GenericKafkaListenerConfigurationBroker> brokers;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Reference to the `Secret` which holds the certificate and private key pair which will be used for this listener. The certificate can optionally contain the whole chain. This field can be used only with listeners with enabled TLS encryption.")
    public CertAndKeySecretSource getBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey;
    }

    public void setBrokerCertChainAndKey(CertAndKeySecretSource brokerCertChainAndKey) {
        this.brokerCertChainAndKey = brokerCertChainAndKey;
    }

    @Description(value="Configures the `Ingress` class that defines which `Ingress` controller will be used. If not set, the `Ingress` class is set to `nginx`. This field can be used only with `ingress` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="class")
    public String getIngressClass() {
        return this.ingressClass;
    }

    public void setIngressClass(String ingressClass) {
        this.ingressClass = ingressClass;
    }

    @Description(value="Defines which address type should be used as the node address. Available types are: `ExternalDNS`, `ExternalIP`, `InternalDNS`, `InternalIP` and `Hostname`. By default, the addresses will be used in the following order (the first one found will be used):\n* `ExternalDNS`\n* `ExternalIP`\n* `InternalDNS`\n* `InternalIP`\n* `Hostname`\n\nThis field can be used to select the address type which will be used as the preferred type and checked first. In case no address will be found for this address type, the other types will be used in the default order.This field can be used only with `nodeport` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public NodeAddressType getPreferredNodePortAddressType() {
        return this.preferredNodePortAddressType;
    }

    public void setPreferredNodePortAddressType(NodeAddressType preferredNodePortAddressType) {
        this.preferredNodePortAddressType = preferredNodePortAddressType;
    }

    @Description(value="Specifies whether the service routes external traffic to node-local or cluster-wide endpoints. `Cluster` may cause a second hop to another node and obscures the client source IP. `Local` avoids a second hop for LoadBalancer and Nodeport type services and preserves the client source IP (when supported by the infrastructure). If unspecified, Kubernetes will use `Cluster` as the default.This field can be used only with `loadbalancer` or `nodeport` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ExternalTrafficPolicy getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public void setExternalTrafficPolicy(ExternalTrafficPolicy externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
    }

    @Description(value="A list of CIDR ranges (for example `10.0.0.0/8` or `130.211.204.1/32`) from which clients can connect to load balancer type listeners. If supported by the platform, traffic through the loadbalancer is restricted to the specified CIDR ranges. This field is applicable only for loadbalancer type services and is ignored if the cloud provider does not support the feature. For more information, see https://v1-17.docs.kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/. This field can be used only with `loadbalancer` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public void setLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    }

    @Description(value="Configures whether the Kubernetes service DNS domain should be used or not. If set to `true`, the generated addresses will contain the service DNS domain suffix (by default `.cluster.local`, can be configured using environment variable `KUBERNETES_SERVICE_DNS_DOMAIN`). Defaults to `false`.This field can be used only with `internal` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getUseServiceDnsDomain() {
        return this.useServiceDnsDomain;
    }

    public void setUseServiceDnsDomain(Boolean useServiceDnsDomain) {
        this.useServiceDnsDomain = useServiceDnsDomain;
    }

    @Description(value="Bootstrap configuration.")
    public GenericKafkaListenerConfigurationBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(GenericKafkaListenerConfigurationBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Description(value="Per-broker configurations.")
    public List<GenericKafkaListenerConfigurationBroker> getBrokers() {
        return this.brokers;
    }

    public void setBrokers(List<GenericKafkaListenerConfigurationBroker> brokers) {
        this.brokers = brokers;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericKafkaListenerConfiguration)) {
            return false;
        }
        GenericKafkaListenerConfiguration other = (GenericKafkaListenerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertAndKeySecretSource this$brokerCertChainAndKey = this.getBrokerCertChainAndKey();
        CertAndKeySecretSource other$brokerCertChainAndKey = other.getBrokerCertChainAndKey();
        if (this$brokerCertChainAndKey == null ? other$brokerCertChainAndKey != null : !((Object)this$brokerCertChainAndKey).equals(other$brokerCertChainAndKey)) {
            return false;
        }
        String this$ingressClass = this.getIngressClass();
        String other$ingressClass = other.getIngressClass();
        if (this$ingressClass == null ? other$ingressClass != null : !this$ingressClass.equals(other$ingressClass)) {
            return false;
        }
        NodeAddressType this$preferredNodePortAddressType = this.getPreferredNodePortAddressType();
        NodeAddressType other$preferredNodePortAddressType = other.getPreferredNodePortAddressType();
        if (this$preferredNodePortAddressType == null ? other$preferredNodePortAddressType != null : !((Object)((Object)this$preferredNodePortAddressType)).equals((Object)other$preferredNodePortAddressType)) {
            return false;
        }
        ExternalTrafficPolicy this$externalTrafficPolicy = this.getExternalTrafficPolicy();
        ExternalTrafficPolicy other$externalTrafficPolicy = other.getExternalTrafficPolicy();
        if (this$externalTrafficPolicy == null ? other$externalTrafficPolicy != null : !((Object)((Object)this$externalTrafficPolicy)).equals((Object)other$externalTrafficPolicy)) {
            return false;
        }
        List<String> this$loadBalancerSourceRanges = this.getLoadBalancerSourceRanges();
        List<String> other$loadBalancerSourceRanges = other.getLoadBalancerSourceRanges();
        if (this$loadBalancerSourceRanges == null ? other$loadBalancerSourceRanges != null : !((Object)this$loadBalancerSourceRanges).equals(other$loadBalancerSourceRanges)) {
            return false;
        }
        Boolean this$useServiceDnsDomain = this.getUseServiceDnsDomain();
        Boolean other$useServiceDnsDomain = other.getUseServiceDnsDomain();
        if (this$useServiceDnsDomain == null ? other$useServiceDnsDomain != null : !((Object)this$useServiceDnsDomain).equals(other$useServiceDnsDomain)) {
            return false;
        }
        GenericKafkaListenerConfigurationBootstrap this$bootstrap = this.getBootstrap();
        GenericKafkaListenerConfigurationBootstrap other$bootstrap = other.getBootstrap();
        if (this$bootstrap == null ? other$bootstrap != null : !((Object)this$bootstrap).equals(other$bootstrap)) {
            return false;
        }
        List<GenericKafkaListenerConfigurationBroker> this$brokers = this.getBrokers();
        List<GenericKafkaListenerConfigurationBroker> other$brokers = other.getBrokers();
        if (this$brokers == null ? other$brokers != null : !((Object)this$brokers).equals(other$brokers)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericKafkaListenerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertAndKeySecretSource $brokerCertChainAndKey = this.getBrokerCertChainAndKey();
        result = result * 59 + ($brokerCertChainAndKey == null ? 43 : ((Object)$brokerCertChainAndKey).hashCode());
        String $ingressClass = this.getIngressClass();
        result = result * 59 + ($ingressClass == null ? 43 : $ingressClass.hashCode());
        NodeAddressType $preferredNodePortAddressType = this.getPreferredNodePortAddressType();
        result = result * 59 + ($preferredNodePortAddressType == null ? 43 : ((Object)((Object)$preferredNodePortAddressType)).hashCode());
        ExternalTrafficPolicy $externalTrafficPolicy = this.getExternalTrafficPolicy();
        result = result * 59 + ($externalTrafficPolicy == null ? 43 : ((Object)((Object)$externalTrafficPolicy)).hashCode());
        List<String> $loadBalancerSourceRanges = this.getLoadBalancerSourceRanges();
        result = result * 59 + ($loadBalancerSourceRanges == null ? 43 : ((Object)$loadBalancerSourceRanges).hashCode());
        Boolean $useServiceDnsDomain = this.getUseServiceDnsDomain();
        result = result * 59 + ($useServiceDnsDomain == null ? 43 : ((Object)$useServiceDnsDomain).hashCode());
        GenericKafkaListenerConfigurationBootstrap $bootstrap = this.getBootstrap();
        result = result * 59 + ($bootstrap == null ? 43 : ((Object)$bootstrap).hashCode());
        List<GenericKafkaListenerConfigurationBroker> $brokers = this.getBrokers();
        result = result * 59 + ($brokers == null ? 43 : ((Object)$brokers).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

