/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.template.ExternalTrafficPolicy;
import io.strimzi.api.kafka.model.template.MetadataTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"metadata", "externalTrafficPolicy", "loadBalancerSourceRanges"})
@DescriptionFile
public class ExternalServiceTemplate
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    private MetadataTemplate metadata;
    private ExternalTrafficPolicy externalTrafficPolicy;
    private List<String> loadBalancerSourceRanges = new ArrayList<String>(0);
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Metadata applied to the resource.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public MetadataTemplate getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataTemplate metadata) {
        this.metadata = metadata;
    }

    @Description(value="Specifies whether the service routes external traffic to node-local or cluster-wide endpoints. `Cluster` may cause a second hop to another node and obscures the client source IP. `Local` avoids a second hop for LoadBalancer and Nodeport type services and preserves the client source IP (when supported by the infrastructure). If unspecified, Kubernetes will use `Cluster` as the default.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @DeprecatedProperty
    @Deprecated
    public ExternalTrafficPolicy getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public void setExternalTrafficPolicy(ExternalTrafficPolicy externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
    }

    @Description(value="A list of CIDR ranges (for example `10.0.0.0/8` or `130.211.204.1/32`) from which clients can connect to load balancer type listeners. If supported by the platform, traffic through the loadbalancer is restricted to the specified CIDR ranges. This field is applicable only for loadbalancer type services and is ignored if the cloud provider does not support the feature. For more information, see https://v1-17.docs.kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/. ")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @DeprecatedProperty
    @Deprecated
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public void setLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalServiceTemplate)) {
            return false;
        }
        ExternalServiceTemplate other = (ExternalServiceTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetadataTemplate this$metadata = this.getMetadata();
        MetadataTemplate other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        ExternalTrafficPolicy this$externalTrafficPolicy = this.getExternalTrafficPolicy();
        ExternalTrafficPolicy other$externalTrafficPolicy = other.getExternalTrafficPolicy();
        if (this$externalTrafficPolicy == null ? other$externalTrafficPolicy != null : !((Object)((Object)this$externalTrafficPolicy)).equals((Object)other$externalTrafficPolicy)) {
            return false;
        }
        List<String> this$loadBalancerSourceRanges = this.getLoadBalancerSourceRanges();
        List<String> other$loadBalancerSourceRanges = other.getLoadBalancerSourceRanges();
        if (this$loadBalancerSourceRanges == null ? other$loadBalancerSourceRanges != null : !((Object)this$loadBalancerSourceRanges).equals(other$loadBalancerSourceRanges)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalServiceTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetadataTemplate $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        ExternalTrafficPolicy $externalTrafficPolicy = this.getExternalTrafficPolicy();
        result = result * 59 + ($externalTrafficPolicy == null ? 43 : ((Object)((Object)$externalTrafficPolicy)).hashCode());
        List<String> $loadBalancerSourceRanges = this.getLoadBalancerSourceRanges();
        result = result * 59 + ($loadBalancerSourceRanges == null ? 43 : ((Object)$loadBalancerSourceRanges).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

