/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.strimzi.api.kafka.model.template.MetadataTemplate;
import io.strimzi.api.kafka.model.template.MetadataTemplateBuilder;
import io.strimzi.api.kafka.model.template.MetadataTemplateFluentImpl;
import io.strimzi.api.kafka.model.template.PodTemplate;
import io.strimzi.api.kafka.model.template.PodTemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PodTemplateFluentImpl<A extends PodTemplateFluent<A>>
extends BaseFluent<A>
implements PodTemplateFluent<A> {
    private MetadataTemplateBuilder metadata;
    private List<LocalObjectReference> imagePullSecrets;
    private PodSecurityContext securityContext;
    private int terminationGracePeriodSeconds;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private List<TopologySpreadConstraint> topologySpreadConstraints;
    private String priorityClassName;
    private String schedulerName;
    private List<HostAlias> hostAliases;

    public PodTemplateFluentImpl() {
    }

    public PodTemplateFluentImpl(PodTemplate instance) {
        this.withMetadata(instance.getMetadata());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withSecurityContext(instance.getSecurityContext());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withAffinity(instance.getAffinity());
        this.withTolerations(instance.getTolerations());
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        this.withPriorityClassName(instance.getPriorityClassName());
        this.withSchedulerName(instance.getSchedulerName());
        this.withHostAliases(instance.getHostAliases());
    }

    @Override
    @Deprecated
    public MetadataTemplate getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public MetadataTemplate buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(MetadataTemplate metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new MetadataTemplateBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PodTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PodTemplateFluent.MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PodTemplateFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PodTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new MetadataTemplateBuilder().build());
    }

    @Override
    public PodTemplateFluent.MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        this.imagePullSecrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        this.imagePullSecrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    @Override
    public LocalObjectReference getImagePullSecret(int index) {
        return this.imagePullSecrets.get(index);
    }

    @Override
    public LocalObjectReference getFirstImagePullSecret() {
        return this.imagePullSecrets.get(0);
    }

    @Override
    public LocalObjectReference getLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1);
    }

    @Override
    public LocalObjectReference getMatchingImagePullSecret(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.imagePullSecrets) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.imagePullSecrets) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get((Object)"imagePullSecrets").removeAll(this.imagePullSecrets);
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public int getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public A withTerminationGracePeriodSeconds(int terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationGracePeriodSeconds() {
        return true;
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get((Object)"tolerations").removeAll(this.tolerations);
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    @Override
    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    @Override
    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    @Override
    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    @Override
    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this._visitables.get((Object)"topologySpreadConstraints").removeAll(this.topologySpreadConstraints);
        }
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    public A withNewPriorityClassName(String arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A withNewPriorityClassName(StringBuilder arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A withNewPriorityClassName(StringBuffer arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    @Override
    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    @Override
    public A withNewSchedulerName(String arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    public A withNewSchedulerName(StringBuilder arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    public A withNewSchedulerName(StringBuffer arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostAliases(HostAlias ... items) {
        for (HostAlias item : items) {
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    @Override
    public HostAlias getHostAlias(int index) {
        return this.hostAliases.get(index);
    }

    @Override
    public HostAlias getFirstHostAlias() {
        return this.hostAliases.get(0);
    }

    @Override
    public HostAlias getLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1);
    }

    @Override
    public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostAliases(List<HostAlias> hostAliases) {
        if (this.hostAliases != null) {
            this._visitables.get((Object)"hostAliases").removeAll(this.hostAliases);
        }
        if (hostAliases != null) {
            this.hostAliases = new ArrayList<HostAlias>();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    @Override
    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodTemplateFluentImpl that = (PodTemplateFluentImpl)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals((Object)that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != that.terminationGracePeriodSeconds) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals((Object)that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.topologySpreadConstraints != null ? !this.topologySpreadConstraints.equals(that.topologySpreadConstraints) : that.topologySpreadConstraints != null) {
            return false;
        }
        if (this.priorityClassName != null ? !this.priorityClassName.equals(that.priorityClassName) : that.priorityClassName != null) {
            return false;
        }
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        return !(this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null);
    }

    public class MetadataNestedImpl<N>
    extends MetadataTemplateFluentImpl<PodTemplateFluent.MetadataNested<N>>
    implements PodTemplateFluent.MetadataNested<N>,
    Nested<N> {
        private final MetadataTemplateBuilder builder;

        MetadataNestedImpl(MetadataTemplate item) {
            this.builder = new MetadataTemplateBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new MetadataTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodTemplateFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

