package io.strimzi.api.kafka.model;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface AbstractConnectorSpecFluent<A extends AbstractConnectorSpecFluent<A>> extends SpecFluent<A> {


    public Integer getTasksMax();
    public A withTasksMax(Integer tasksMax);
    public Boolean hasTasksMax();
    public Boolean getPause();
    public A withPause(Boolean pause);
    public Boolean hasPause();
    public A withNewPause(String arg1);
    public A withNewPause(boolean arg1);
    public A addToConfig(String key,Object value);
    public A addToConfig(Map<String,Object> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,Object> map);
    public Map<String,Object> getConfig();
    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config);
    public Boolean hasConfig();
}
