package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AclRuleBuilder extends AclRuleFluentImpl<AclRuleBuilder> implements VisitableBuilder<AclRule,AclRuleBuilder> {

    AclRuleFluent<?> fluent;
    Boolean validationEnabled;

    public AclRuleBuilder() {
        this(true);
    }

    public AclRuleBuilder(Boolean validationEnabled) {
        this(new AclRule(), validationEnabled);
    }

    public AclRuleBuilder(AclRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public AclRuleBuilder(AclRuleFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AclRule(), validationEnabled);
    }

    public AclRuleBuilder(AclRuleFluent<?> fluent,AclRule instance) {
        this(fluent, instance, true);
    }

    public AclRuleBuilder(AclRuleFluent<?> fluent,AclRule instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withType(instance.getType()); 
        fluent.withResource(instance.getResource()); 
        fluent.withHost(instance.getHost()); 
        fluent.withOperation(instance.getOperation()); 
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleBuilder(AclRule instance) {
        this(instance,true);
    }

    public AclRuleBuilder(AclRule instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withType(instance.getType()); 
        this.withResource(instance.getResource()); 
        this.withHost(instance.getHost()); 
        this.withOperation(instance.getOperation()); 
        this.validationEnabled = validationEnabled; 
    }

    public AclRule build() {
        AclRule buildable = new AclRule(fluent.getType(),fluent.getResource(),fluent.getHost(),fluent.getOperation());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AclRuleBuilder that = (AclRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
