package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class AclRuleFluentImpl<A extends AclRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AclRuleFluent<A> {

    private AclRuleType type;
    private VisitableBuilder<? extends AclRuleResource,?> resource;
    private String host;
    private AclOperation operation;

    public AclRuleFluentImpl() {
    }

    public AclRuleFluentImpl(AclRule instance) {
        this.withType(instance.getType()); 
        this.withResource(instance.getResource()); 
        this.withHost(instance.getHost()); 
        this.withOperation(instance.getOperation()); 
    }

    public AclRuleType getType() {
        return this.type;
    }

    public A withType(AclRuleType type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    
/**
 * This method has been deprecated, please use method buildResource instead.
 * @return The buildable object.
 */
@Deprecated public AclRuleResource getResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public AclRuleResource buildResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public A withResource(AclRuleResource resource) {
        if (resource instanceof AclRuleGroupResource){ this.resource= new AclRuleGroupResourceBuilder((AclRuleGroupResource)resource); _visitables.get("resource").add(this.resource);}
        if (resource instanceof AclRuleTopicResource){ this.resource= new AclRuleTopicResourceBuilder((AclRuleTopicResource)resource); _visitables.get("resource").add(this.resource);}
        if (resource instanceof AclRuleTransactionalIdResource){ this.resource= new AclRuleTransactionalIdResourceBuilder((AclRuleTransactionalIdResource)resource); _visitables.get("resource").add(this.resource);}
        if (resource instanceof AclRuleClusterResource){ this.resource= new AclRuleClusterResourceBuilder((AclRuleClusterResource)resource); _visitables.get("resource").add(this.resource);}
        return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public A withAclRuleGroupResource(AclRuleGroupResource aclRuleGroupResource) {
        _visitables.get("resource").remove(this.resource);
        if (aclRuleGroupResource!=null){ this.resource= new AclRuleGroupResourceBuilder(aclRuleGroupResource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public AclRuleFluent.AclRuleGroupResourceNested<A> withNewAclRuleGroupResource() {
        return new AclRuleGroupResourceNestedImpl();
    }

    public AclRuleFluent.AclRuleGroupResourceNested<A> withNewAclRuleGroupResourceLike(AclRuleGroupResource item) {
        return new AclRuleGroupResourceNestedImpl(item);
    }

    public A withAclRuleTopicResource(AclRuleTopicResource aclRuleTopicResource) {
        _visitables.get("resource").remove(this.resource);
        if (aclRuleTopicResource!=null){ this.resource= new AclRuleTopicResourceBuilder(aclRuleTopicResource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public AclRuleFluent.AclRuleTopicResourceNested<A> withNewAclRuleTopicResource() {
        return new AclRuleTopicResourceNestedImpl();
    }

    public AclRuleFluent.AclRuleTopicResourceNested<A> withNewAclRuleTopicResourceLike(AclRuleTopicResource item) {
        return new AclRuleTopicResourceNestedImpl(item);
    }

    public A withAclRuleTransactionalIdResource(AclRuleTransactionalIdResource aclRuleTransactionalIdResource) {
        _visitables.get("resource").remove(this.resource);
        if (aclRuleTransactionalIdResource!=null){ this.resource= new AclRuleTransactionalIdResourceBuilder(aclRuleTransactionalIdResource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public AclRuleFluent.AclRuleTransactionalIdResourceNested<A> withNewAclRuleTransactionalIdResource() {
        return new AclRuleTransactionalIdResourceNestedImpl();
    }

    public AclRuleFluent.AclRuleTransactionalIdResourceNested<A> withNewAclRuleTransactionalIdResourceLike(AclRuleTransactionalIdResource item) {
        return new AclRuleTransactionalIdResourceNestedImpl(item);
    }

    public A withAclRuleClusterResource(AclRuleClusterResource aclRuleClusterResource) {
        _visitables.get("resource").remove(this.resource);
        if (aclRuleClusterResource!=null){ this.resource= new AclRuleClusterResourceBuilder(aclRuleClusterResource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public AclRuleFluent.AclRuleClusterResourceNested<A> withNewAclRuleClusterResource() {
        return new AclRuleClusterResourceNestedImpl();
    }

    public AclRuleFluent.AclRuleClusterResourceNested<A> withNewAclRuleClusterResourceLike(AclRuleClusterResource item) {
        return new AclRuleClusterResourceNestedImpl(item);
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host=host; return (A) this;
    }

    public Boolean hasHost() {
        return this.host != null;
    }

    public A withNewHost(StringBuilder arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(int[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(char[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(byte[] arg1,int arg2) {
        return (A)withHost(new String(arg1, arg2));
    }

    public A withNewHost(byte[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(char[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHost(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHost(String arg1) {
        return (A)withHost(new String(arg1));
    }

    public AclOperation getOperation() {
        return this.operation;
    }

    public A withOperation(AclOperation operation) {
        this.operation=operation; return (A) this;
    }

    public Boolean hasOperation() {
        return this.operation != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AclRuleFluentImpl that = (AclRuleFluentImpl) o;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (operation != null ? !operation.equals(that.operation) :that.operation != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(type,  resource,  host,  operation,  super.hashCode());
    }

    public class AclRuleGroupResourceNestedImpl<N> extends AclRuleGroupResourceFluentImpl<AclRuleFluent.AclRuleGroupResourceNested<N>> implements AclRuleFluent.AclRuleGroupResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AclRuleGroupResourceBuilder builder;

            AclRuleGroupResourceNestedImpl(AclRuleGroupResource item) {
                this.builder = new AclRuleGroupResourceBuilder(this, item);
                        
            }

            AclRuleGroupResourceNestedImpl() {
                this.builder = new AclRuleGroupResourceBuilder(this);
                        
            }

            public N and() {
                return (N) AclRuleFluentImpl.this.withResource(builder.build());
            }

            public N endAclRuleGroupResource() {
                return and();
            }
    }


    public class AclRuleTopicResourceNestedImpl<N> extends AclRuleTopicResourceFluentImpl<AclRuleFluent.AclRuleTopicResourceNested<N>> implements AclRuleFluent.AclRuleTopicResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AclRuleTopicResourceBuilder builder;

            AclRuleTopicResourceNestedImpl(AclRuleTopicResource item) {
                this.builder = new AclRuleTopicResourceBuilder(this, item);
                        
            }

            AclRuleTopicResourceNestedImpl() {
                this.builder = new AclRuleTopicResourceBuilder(this);
                        
            }

            public N and() {
                return (N) AclRuleFluentImpl.this.withResource(builder.build());
            }

            public N endAclRuleTopicResource() {
                return and();
            }
    }


    public class AclRuleTransactionalIdResourceNestedImpl<N> extends AclRuleTransactionalIdResourceFluentImpl<AclRuleFluent.AclRuleTransactionalIdResourceNested<N>> implements AclRuleFluent.AclRuleTransactionalIdResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AclRuleTransactionalIdResourceBuilder builder;

            AclRuleTransactionalIdResourceNestedImpl(AclRuleTransactionalIdResource item) {
                this.builder = new AclRuleTransactionalIdResourceBuilder(this, item);
                        
            }

            AclRuleTransactionalIdResourceNestedImpl() {
                this.builder = new AclRuleTransactionalIdResourceBuilder(this);
                        
            }

            public N and() {
                return (N) AclRuleFluentImpl.this.withResource(builder.build());
            }

            public N endAclRuleTransactionalIdResource() {
                return and();
            }
    }


    public class AclRuleClusterResourceNestedImpl<N> extends AclRuleClusterResourceFluentImpl<AclRuleFluent.AclRuleClusterResourceNested<N>> implements AclRuleFluent.AclRuleClusterResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AclRuleClusterResourceBuilder builder;

            AclRuleClusterResourceNestedImpl(AclRuleClusterResource item) {
                this.builder = new AclRuleClusterResourceBuilder(this, item);
                        
            }

            AclRuleClusterResourceNestedImpl() {
                this.builder = new AclRuleClusterResourceBuilder(this);
                        
            }

            public N and() {
                return (N) AclRuleFluentImpl.this.withResource(builder.build());
            }

            public N endAclRuleClusterResource() {
                return and();
            }
    }


}
